//GPT-4o-mini DATASET v1.0 Category: Searching algorithm ; Style: happy
#include <stdio.h>
#include <stdlib.h>
#include <string.h>
#include <time.h>

#define GARDEN_SIZE 20

// Function to simulate planting treasures in the garden
void plantTreasures(char garden[], int size) {
    // Use a seed for randomness
    srand(time(NULL));
    
    for (int i = 0; i < size; i++) {
        // Plant either a treasure (T) or empty space (.)
        garden[i] = (rand() % 4 == 0) ? 'T' : '.';
    }
}

// Function to conduct a joyful search for treasures
void searchForTreasure(char garden[], int size) {
    int found = 0; // To keep track of treasures found
    printf("🎉 Let's explore the magical garden for treasures! 🎉\n");
    
    for (int i = 0; i < size; i++) {
        printf("🌼 Checking spot %d: ", i);
        
        if (garden[i] == 'T') {
            printf("💎 Hooray! Found a treasure at spot %d! 🎊\n", i);
            found++;
        } else {
            printf("Oops! Just a flower here. 🌸\n");
        }
    }
    
    if (found == 0) {
        printf("😢 No treasures found today, but keep looking! 🌈\n");
    } else {
        printf("🥳 Treasures found: %d! What a successful adventure! 🌟\n", found);
    }
}

// Function to display the garden
void displayGarden(char garden[], int size) {
    printf("\n🌳 Here's the magical garden: \n");
    for (int i = 0; i < size; i++) {
        printf("%c ", garden[i]);
    }
    printf("\n");
}

int main() {
    // Create a magical garden
    char garden[GARDEN_SIZE];

    // Plant treasures in the garden
    plantTreasures(garden, GARDEN_SIZE);
    
    // Display the magical garden
    displayGarden(garden, GARDEN_SIZE);
    
    // Go on a joyous search for treasures
    searchForTreasure(garden, GARDEN_SIZE);
    
    printf("\n✨ Thanks for joining the treasure hunt in the magical garden! Until next time! 🌈\n");
    
    return 0;
}