//Falcon-180B DATASET v1.0 Category: Phone Book ; Style: Romeo and Juliet
#include <stdio.h>
#include <stdlib.h>

// Define the structure of a phone book entry
typedef struct {
    char name[30];
    int phone_number;
} PhoneBookEntry;

// Function to add a new entry to the phone book
void add_entry(PhoneBookEntry* entries, int num_entries, char* name, int phone_number) {
    if (num_entries >= 1000) { // Phone book is full
        printf("Alas, the phone book is full. No more entries can be added.\n");
        return;
    }

    strcpy(entries[num_entries].name, name);
    entries[num_entries].phone_number = phone_number;
    num_entries++;
}

// Function to search for an entry in the phone book
int search_entry(PhoneBookEntry* entries, int num_entries, char* name) {
    for (int i = 0; i < num_entries; i++) {
        if (strcmp(entries[i].name, name) == 0) {
            return entries[i].phone_number;
        }
    }

    printf("No such entry found in the phone book.\n");
    return -1;
}

// Function to delete an entry from the phone book
void delete_entry(PhoneBookEntry* entries, int num_entries, char* name) {
    for (int i = 0; i < num_entries; i++) {
        if (strcmp(entries[i].name, name) == 0) {
            for (int j = i; j < num_entries - 1; j++) {
                strcpy(entries[j].name, entries[j + 1].name);
                entries[j].phone_number = entries[j + 1].phone_number;
            }
            num_entries--;
            break;
        }
    }
}

int main() {
    PhoneBookEntry entries[1000];
    int num_entries = 0;

    // Initialize the phone book with some famous Shakespearean characters
    add_entry(entries, num_entries, "Romeo", 5551234);
    add_entry(entries, num_entries, "Juliet", 5555678);
    add_entry(entries, num_entries, "Mercutio", 5559876);
    add_entry(entries, num_entries, "Tybalt", 5562468);

    // Demonstrate adding, searching, and deleting entries
    add_entry(entries, num_entries, "Nurse", 5554321);
    printf("Added Nurse to the phone book.\n");

    int juliet_number = search_entry(entries, num_entries, "Juliet");
    printf("Juliet's phone number is: %d\n", juliet_number);

    delete_entry(entries, num_entries, "Mercutio");
    printf("Deleted Mercutio from the phone book.\n");

    return 0;
}