//Code Llama-13B DATASET v1.0 Category: Socket programming ; Style: Claude Shannon
#include <sys/socket.h>
  #include <netinet/in.h>
  #include <arpa/inet.h>
  #include <unistd.h>

  int main(int argc, char *argv[]) {
      int sockfd, newsockfd, portno;
      socklen_t clilen;
      char buffer[256];
      struct sockaddr_in serv_addr, cli_addr;

      // Create a socket
      sockfd = socket(AF_INET, SOCK_STREAM, 0);
      if (sockfd < 0) {
          perror("ERROR opening socket");
          exit(1);
      }

      // Initialize the server address
      bzero((char *) &serv_addr, sizeof(serv_addr));
      serv_addr.sin_family = AF_INET;
      serv_addr.sin_addr.s_addr = INADDR_ANY;
      serv_addr.sin_port = htons(portno);

      // Bind the socket to the server address
      if (bind(sockfd, (struct sockaddr *) &serv_addr, sizeof(serv_addr)) < 0) {
          perror("ERROR on binding");
          exit(1);
      }

      // Listen for incoming connections
      listen(sockfd, 5);

      // Accept an incoming connection
      clilen = sizeof(cli_addr);
      newsockfd = accept(sockfd, (struct sockaddr *) &cli_addr, &clilen);
      if (newsockfd < 0) {
          perror("ERROR on accept");
          exit(1);
      }

      // Receive and print the incoming message
      recv(newsockfd, buffer, 255, 0);
      printf("Received message: %s\n", buffer);

      // Send a response to the client
      send(newsockfd, "Hello, client!", 13, 0);

      // Close the connection
      close(newsockfd);
      close(sockfd);

      return 0;
  }