//Falcon-180B DATASET v1.0 Category: Network Packet Monitoring ; Style: high level of detail
#include <stdio.h>
#include <stdlib.h>
#include <string.h>
#include <pcap.h>
#include <ctype.h>

#define MAX_PACKET_SIZE 65535
#define MAX_DATA_SIZE 1024

struct packet_data {
    u_char *data;
    u_int size;
};

void print_packet_data(struct packet_data *packet_data) {
    printf("Packet Data:\n");
    printf("---------------------\n");
    for (int i = 0; i < packet_data->size; i++) {
        if (isprint(packet_data->data[i])) {
            printf("%c", packet_data->data[i]);
        } else {
            printf(". ");
        }
    }
    printf("\n");
}

void packet_handler(u_char *args, const struct pcap_pkthdr *header, const u_char *packet) {
    struct packet_data packet_data;
    packet_data.data = (u_char *) malloc(header->caplen);
    if (packet_data.data == NULL) {
        fprintf(stderr, "Error: Could not allocate memory for packet data\n");
        exit(1);
    }
    packet_data.size = header->caplen;
    memcpy(packet_data.data, packet, header->caplen);

    print_packet_data(&packet_data);
    free(packet_data.data);
}

int main() {
    char *dev = "eth0";
    char errbuf[PCAP_ERRBUF_SIZE];
    pcap_t *handle;
    struct bpf_program filter;

    handle = pcap_open_live(dev, 65535, 0, 0, errbuf);
    if (handle == NULL) {
        fprintf(stderr, "Error: Could not open device %s\n", dev);
        exit(1);
    }

    if (pcap_compile(handle, &filter, "tcp or udp", 0, 0) == -1) {
        fprintf(stderr, "Error: Could not compile filter\n");
        exit(1);
    }

    if (pcap_setfilter(handle, &filter) == -1) {
        fprintf(stderr, "Error: Could not set filter\n");
        exit(1);
    }

    printf("Monitoring network traffic on device %s...\n", dev);

    pcap_loop(handle, -1, packet_handler, NULL);

    pcap_freecode(&filter);
    pcap_close(handle);

    return 0;
}