//GEMINI-pro DATASET v1.0 Category: Digital Auction System ; Style: random
#include <stdio.h>
#include <stdlib.h>
#include <string.h>

#define MAX_ITEMS 100
#define MAX_BIDS 10

typedef struct {
    char name[50];
    int price;
} Item;

typedef struct {
    char name[50];
    int bid;
} Bid;

Item items[MAX_ITEMS];
Bid bids[MAX_BIDS];

int numItems = 0;
int numBids = 0;

void addItem(char *name, int price) {
    if (numItems < MAX_ITEMS) {
        strcpy(items[numItems].name, name);
        items[numItems].price = price;
        numItems++;
    }
}

void addBid(char *name, int bid) {
    if (numBids < MAX_BIDS) {
        strcpy(bids[numBids].name, name);
        bids[numBids].bid = bid;
        numBids++;
    }
}

int main() {
    addItem("Painting", 100);
    addItem("Sculpture", 200);
    addItem("Vase", 50);

    addBid("John", 150);
    addBid("Mary", 220);
    addBid("Bob", 60);

    printf("Items:\n");
    for (int i = 0; i < numItems; i++) {
        printf("%s: $%d\n", items[i].name, items[i].price);
    }

    printf("\nBids:\n");
    for (int i = 0; i < numBids; i++) {
        printf("%s: $%d\n", bids[i].name, bids[i].bid);
    }

    return 0;
}