//LLAMA2-13B DATASET v1.0 Category: Unit converter ; Style: statistical
#include <stdio.h>
#include <stdlib.h>
#include <string.h>
#include <time.h>

#define MAX_UNITS 10
#define MAX_CONVERTIONS 5

// Structure to store unit information
typedef struct {
    char *name;    // Unit name (e.g. "inch", "foot", "yard")
    double factor; // Conversion factor (e.g. 12 for inches to feet)
} Unit;

// Array to store all units
Unit units[MAX_UNITS] = {
    {"inch", 1},
    {"foot", 12},
    {"yard", 36},
    {"mile", 5280},
    {"kilometer", 1000}
};

// Function to convert a value from one unit to another
double convert(double value, char from_unit[], char to_unit[]) {
    int i = 0;
    for (i = 0; i < MAX_UNITS; i++) {
        if (strcmp(from_unit, units[i].name) == 0) {
            break;
        }
    }
    if (i == MAX_UNITS) {
        printf("Invalid unit: %s\n", from_unit);
        return 0;
    }
    double factor = units[i].factor;
    for (i = 0; i < MAX_UNITS; i++) {
        if (strcmp(to_unit, units[i].name) == 0) {
            break;
        }
    }
    if (i == MAX_UNITS) {
        printf("Invalid unit: %s\n", to_unit);
        return 0;
    }
    return value * factor / units[i].factor;
}

int main() {
    srand(time(NULL)); // Seed the random number generator
    double value = (double)rand() / RAND_MAX; // Generate a random value
    char from_unit[] = "inch";
    char to_unit[] = "foot";
    double converted_value = convert(value, from_unit, to_unit);
    printf("Value in %s: %f\n", from_unit, value);
    printf("Value in %s: %f\n", to_unit, converted_value);
    return 0;
}