//Falcon-180B DATASET v1.0 Category: Procedurally Generated Maze ; Style: Alan Turing
#include <stdio.h>
#include <stdlib.h>
#include <time.h>

#define N 10
#define M 10
#define WALL 0
#define PATH 1
#define VISITED 2
#define STACK_SIZE 100

int maze[N][M];
int stack[STACK_SIZE][2];
int top = -1;

void init_maze() {
    int i, j;
    for (i = 0; i < N; i++) {
        for (j = 0; j < M; j++) {
            maze[i][j] = WALL;
        }
    }
}

void print_maze() {
    int i, j;
    for (i = 0; i < N; i++) {
        for (j = 0; j < M; j++) {
            if (maze[i][j] == WALL) {
                printf("#");
            } else if (maze[i][j] == PATH) {
                printf(" ");
            }
        }
        printf("\n");
    }
}

void dfs(int x, int y) {
    int i, j, k;
    int dx[] = {0, 0, -1, 1};
    int dy[] = {-1, 1, 0, 0};

    maze[x][y] = PATH;

    for (k = 0; k < 4; k++) {
        i = x + dx[k];
        j = y + dy[k];

        if (i >= 0 && i < N && j >= 0 && j < M && maze[i][j] == WALL) {
            maze[i][j] = PATH;
            stack[++top][0] = i;
            stack[top][1] = j;
        }
    }
}

int main() {
    int i, j;
    srand(time(NULL));

    init_maze();

    for (i = 0; i < N; i++) {
        dfs(i, rand() % M);
    }

    print_maze();

    return 0;
}