//GEMINI-pro DATASET v1.0 Category: Geometric algorithms ; Style: Sherlock Holmes
#include <stdio.h>
#include <stdlib.h>
#include <math.h>

#define PI 3.14159265

typedef struct {
    double x;
    double y;
} Point;

typedef struct {
    Point p1;
    Point p2;
} Line;

typedef struct {
    Point center;
    double radius;
} Circle;

// Function to check if a point is inside a circle
int is_inside_circle(Point point, Circle circle) {
    double dx = point.x - circle.center.x;
    double dy = point.y - circle.center.y;
    double distance = sqrt(dx * dx + dy * dy);
    return distance <= circle.radius;
}

// Function to check if a line intersects a circle
int does_line_intersect_circle(Line line, Circle circle) {
    // Check if the line passes through the center of the circle
    double dx = line.p2.x - line.p1.x;
    double dy = line.p2.y - line.p1.y;
    double a = dx * dx + dy * dy;
    double b = 2 * (dx * (line.p1.x - circle.center.x) + dy * (line.p1.y - circle.center.y));
    double c = (line.p1.x - circle.center.x) * (line.p1.x - circle.center.x) + (line.p1.y - circle.center.y) * (line.p1.y - circle.center.y) - circle.radius * circle.radius;
    double discriminant = b * b - 4 * a * c;
    if (discriminant < 0) {
        return 0;
    }

    // Check if the line intersects the circle at one point
    double t = (-b + sqrt(discriminant)) / (2 * a);
    if (t >= 0 && t <= 1) {
        return 1;
    }

    // Check if the line intersects the circle at two points
    t = (-b - sqrt(discriminant)) / (2 * a);
    if (t >= 0 && t <= 1) {
        return 1;
    }

    // The line does not intersect the circle
    return 0;
}

// Function to find the intersection point of a line and a circle
Point find_line_circle_intersection(Line line, Circle circle) {
    // Check if the line intersects the circle
    if (!does_line_intersect_circle(line, circle)) {
        return (Point) { -1, -1 };
    }

    // Find the two intersection points
    double dx = line.p2.x - line.p1.x;
    double dy = line.p2.y - line.p1.y;
    double a = dx * dx + dy * dy;
    double b = 2 * (dx * (line.p1.x - circle.center.x) + dy * (line.p1.y - circle.center.y));
    double c = (line.p1.x - circle.center.x) * (line.p1.x - circle.center.x) + (line.p1.y - circle.center.y) * (line.p1.y - circle.center.y) - circle.radius * circle.radius;
    double discriminant = b * b - 4 * a * c;
    double t1 = (-b + sqrt(discriminant)) / (2 * a);
    double t2 = (-b - sqrt(discriminant)) / (2 * a);

    // Return the first intersection point
    if (t1 >= 0 && t1 <= 1) {
        return (Point) { line.p1.x + t1 * dx, line.p1.y + t1 * dy };
    }

    // Return the second intersection point
    return (Point) { line.p1.x + t2 * dx, line.p1.y + t2 * dy };
}

int main() {
    // Define a point
    Point point = { 1, 1 };

    // Define a circle
    Circle circle = { { 0, 0 }, 2 };

    // Check if the point is inside the circle
    if (is_inside_circle(point, circle)) {
        printf("The point is inside the circle.\n");
    } else {
        printf("The point is outside the circle.\n");
    }

    // Define a line
    Line line = { { -1, 1 }, { 1, -1 } };

    // Check if the line intersects the circle
    if (does_line_intersect_circle(line, circle)) {
        printf("The line intersects the circle.\n");
    } else {
        printf("The line does not intersect the circle.\n");
    }

    // Find the intersection point of the line and the circle
    Point intersection_point = find_line_circle_intersection(line, circle);
    printf("The intersection point is (%f, %f).\n", intersection_point.x, intersection_point.y);

    return 0;
}