//Falcon-180B DATASET v1.0 Category: TCP/IP Programming ; Style: multivariable
#include <stdio.h>
#include <stdlib.h>
#include <string.h>
#include <sys/socket.h>
#include <arpa/inet.h>
#include <unistd.h>

int main() {
    int sockfd, newsockfd, portno;
    struct sockaddr_in serv_addr, cli_addr;
    char buffer[1024];
    int n;
    int valread;
    int sd;
    char *message = "Welcome to the server!";

    // create socket
    sockfd = socket(AF_INET, SOCK_STREAM, 0);
    if (sockfd < 0) {
        perror("socket failed");
        exit(EXIT_FAILURE);
    }

    puts("Socket created");

    // set the port number
    portno = 8080;

    // server address structure
    serv_addr.sin_family = AF_INET;
    serv_addr.sin_addr.s_addr = INADDR_ANY;
    serv_addr.sin_port = htons(portno);

    // bind the server address structure to the socket
    if (bind(sockfd, (struct sockaddr *)&serv_addr, sizeof(serv_addr)) < 0) {
        perror("bind failed");
        exit(EXIT_FAILURE);
    }

    puts("Bind done");

    // start listening for incoming connections
    listen(sockfd, 5);
    puts("Server is listening");

    // accept a connection
    sd = accept(sockfd, (struct sockaddr *)&cli_addr, sizeof(cli_addr));
    if (sd < 0) {
        perror("accept failed");
        exit(EXIT_FAILURE);
    }

    puts("Connection accepted");

    // send a message to the client
    n = write(sd, message, strlen(message));
    if (n < 0) {
        perror("write failed");
        exit(EXIT_FAILURE);
    }

    puts("Message sent");

    // receive a message from the client
    n = read(sd, buffer, sizeof(buffer));
    if (n < 0) {
        perror("read failed");
        exit(EXIT_FAILURE);
    }

    puts("Message received");

    // close the connection
    close(sd);
    close(sockfd);

    return 0;
}