//Code Llama-13B DATASET v1.0 Category: Remote control Vehicle Simulation ; Style: interoperable
#include <stdio.h>
#include <stdlib.h>
#include <string.h>
#include <stdbool.h>
#include <stdint.h>

#define MAX_VEHICLES 10
#define MAX_COMMANDS 10

typedef struct {
  char *name;
  int speed;
  int direction;
  bool is_moving;
} Vehicle;

typedef struct {
  char *command;
  int vehicle_id;
} Command;

Vehicle vehicles[MAX_VEHICLES];
Command commands[MAX_COMMANDS];

int num_vehicles = 0;
int num_commands = 0;

void print_vehicles() {
  for (int i = 0; i < num_vehicles; i++) {
    Vehicle *v = &vehicles[i];
    printf("Vehicle %d: %s (speed: %d, direction: %d)\n", i, v->name, v->speed, v->direction);
  }
}

void print_commands() {
  for (int i = 0; i < num_commands; i++) {
    Command *c = &commands[i];
    printf("Command %d: %s (vehicle id: %d)\n", i, c->command, c->vehicle_id);
  }
}

void process_command(Command *c) {
  Vehicle *v = &vehicles[c->vehicle_id];
  if (strcmp(c->command, "move") == 0) {
    v->is_moving = true;
  } else if (strcmp(c->command, "stop") == 0) {
    v->is_moving = false;
  }
}

int main() {
  Vehicle v1 = {"Car", 50, 0, false};
  Vehicle v2 = {"Truck", 20, 0, false};
  Vehicle v3 = {"Bicycle", 10, 0, false};
  Vehicle v4 = {"Scooter", 20, 0, false};
  Vehicle v5 = {"Motorcycle", 30, 0, false};
  vehicles[0] = v1;
  vehicles[1] = v2;
  vehicles[2] = v3;
  vehicles[3] = v4;
  vehicles[4] = v5;
  num_vehicles = 5;

  Command c1 = {"move", 0};
  Command c2 = {"stop", 1};
  Command c3 = {"move", 2};
  Command c4 = {"stop", 3};
  Command c5 = {"move", 4};
  commands[0] = c1;
  commands[1] = c2;
  commands[2] = c3;
  commands[3] = c4;
  commands[4] = c5;
  num_commands = 5;

  print_vehicles();
  print_commands();

  for (int i = 0; i < num_commands; i++) {
    Command *c = &commands[i];
    process_command(c);
  }

  print_vehicles();

  return 0;
}