//Falcon-180B DATASET v1.0 Category: Data structures visualization ; Style: multiplayer
#include <stdio.h>
#include <stdlib.h>
#include <string.h>
#include <time.h>

#define NUM_PLAYERS 4
#define NUM_ROUNDS 10

typedef struct {
    char name[20];
    int score;
} Player;

void init_player(Player *player, char *name) {
    strcpy(player->name, name);
    player->score = 0;
}

typedef struct {
    Player players[NUM_PLAYERS];
    int round;
    int current_player;
} Game;

void init_game(Game *game) {
    for (int i = 0; i < NUM_PLAYERS; i++) {
        init_player(&game->players[i], "Player ");
    }
    game->round = 0;
    game->current_player = 0;
}

void play_game(Game *game) {
    int dice_roll;
    for (int round = 0; round < NUM_ROUNDS; round++) {
        printf("Round %d:\n", round + 1);
        for (int player = 0; player < NUM_PLAYERS; player++) {
            printf("Player %d's turn:\n", player + 1);
            dice_roll = rand() % 6 + 1;
            printf("Dice roll: %d\n", dice_roll);
            game->players[player].score += dice_roll;
            if (game->players[player].score >= 21) {
                printf("Player %d wins!\n", player + 1);
                game->current_player = player;
                break;
            } else {
                printf("Player %d's score: %d\n", player + 1, game->players[player].score);
            }
        }
        printf("\n");
    }
}

int main() {
    Game game;
    init_game(&game);
    play_game(&game);
    return 0;
}