//Gemma-7B DATASET v1.0 Category: Scientific Calculator Implementation ; Style: post-apocalyptic
#include <stdio.h>
#include <stdlib.h>

#define MAX_BUFFER_SIZE 256

char buffer[MAX_BUFFER_SIZE];
int buffer_pos = 0;
char operator = '\0';

void clear_buffer() {
  buffer_pos = 0;
  operator = '\0';
}

void add_to_buffer(char num) {
  if (buffer_pos >= MAX_BUFFER_SIZE - 1) {
    return;
  }
  buffer[buffer_pos++] = num;
}

void process_operator(char op) {
  operator = op;
}

int main() {
  clear_buffer();
  add_to_buffer(5);
  add_to_buffer(3);
  process_operator('+');
  add_to_buffer(8);
  add_to_buffer(2);
  process_operator('-');
  add_to_buffer(6);
  add_to_buffer(4);
  process_operator('*');
  add_to_buffer(2);
  process_operator('/');
  add_to_buffer(3);

  int result = calculate_expression();

  printf("The result is: %d\n", result);

  return 0;
}

int calculate_expression() {
  int num1 = buffer[0] - '0';
  int num2 = buffer[1] - '0';

  switch (operator) {
    case '+':
      return num1 + num2;
    case '-':
      return num1 - num2;
    case '*':
      return num1 * num2;
    case '/':
      return num1 / num2;
    default:
      return -1;
  }
}