//GEMINI-pro DATASET v1.0 Category: Color Code Converter ; Style: mathematical
#include <stdio.h>
#include <stdlib.h>
#include <math.h>

// Define the RGB color space
typedef struct {
    double r;
    double g;
    double b;
} rgb_color;

// Define the HSL color space
typedef struct {
    double h;
    double s;
    double l;
} hsl_color;

// Convert an RGB color to an HSL color
hsl_color rgb_to_hsl(rgb_color rgb) {
    hsl_color hsl;

    // Calculate the hue
    double min = fmin(rgb.r, fmin(rgb.g, rgb.b));
    double max = fmax(rgb.r, fmax(rgb.g, rgb.b));
    double delta = max - min;

    if (delta == 0) {
        hsl.h = 0;
    } else if (max == rgb.r) {
        hsl.h = 60 * fmod((rgb.g - rgb.b) / delta, 6);
    } else if (max == rgb.g) {
        hsl.h = 60 * ((rgb.b - rgb.r) / delta + 2);
    } else {
        hsl.h = 60 * ((rgb.r - rgb.g) / delta + 4);
    }

    // Calculate the saturation
    if (max == 0) {
        hsl.s = 0;
    } else {
        hsl.s = delta / max;
    }

    // Calculate the lightness
    hsl.l = (max + min) / 2;

    return hsl;
}

// Convert an HSL color to an RGB color
rgb_color hsl_to_rgb(hsl_color hsl) {
    rgb_color rgb;

    double c = (1 - fabs(2 * hsl.l - 1)) * hsl.s;
    double x = c * (1 - fabs(fmod(hsl.h / 60, 2) - 1));
    double m = hsl.l - c / 2;

    if (hsl.h < 60) {
        rgb.r = c + m;
        rgb.g = x + m;
        rgb.b = m;
    } else if (hsl.h < 120) {
        rgb.r = x + m;
        rgb.g = c + m;
        rgb.b = m;
    } else if (hsl.h < 180) {
        rgb.r = m;
        rgb.g = c + m;
        rgb.b = x + m;
    } else if (hsl.h < 240) {
        rgb.r = m;
        rgb.g = x + m;
        rgb.b = c + m;
    } else if (hsl.h < 300) {
        rgb.r = x + m;
        rgb.g = m;
        rgb.b = c + m;
    } else {
        rgb.r = c + m;
        rgb.g = m;
        rgb.b = x + m;
    }

    return rgb;
}

// Print an RGB color
void print_rgb(rgb_color rgb) {
    printf("RGB(%f, %f, %f)\n", rgb.r, rgb.g, rgb.b);
}

// Print an HSL color
void print_hsl(hsl_color hsl) {
    printf("HSL(%f, %f, %f)\n", hsl.h, hsl.s, hsl.l);
}

// Main function
int main() {
    // Define an RGB color
    rgb_color rgb = {0.5, 0.5, 0.5};

    // Convert the RGB color to an HSL color
    hsl_color hsl = rgb_to_hsl(rgb);

    // Print the RGB and HSL colors
    printf("RGB: ");
    print_rgb(rgb);
    printf("HSL: ");
    print_hsl(hsl);

    return 0;
}