//GEMINI-pro DATASET v1.0 Category: URL Sanitizer ; Style: all-encompassing
#include <stdio.h>
#include <stdlib.h>
#include <string.h>
#include <ctype.h>
#include <stdbool.h>

#define MAX_URL_LENGTH 2048

// Function to check if a character is valid in a URL
bool is_valid_url_char(char c) {
    return isalnum(c) || c == '-' || c == '_' || c == '.' || c == '/' || c == ':' || c == '@' || c == '?' || c == '&' || c == '=';
}

// Function to sanitize a URL
char *sanitize_url(char *url) {
    char *sanitized_url = malloc(MAX_URL_LENGTH);
    if (sanitized_url == NULL) {
        return NULL;
    }

    int i = 0;
    int j = 0;
    while (url[i] != '\0') {
        if (is_valid_url_char(url[i])) {
            sanitized_url[j++] = url[i];
        }
        i++;
    }

    sanitized_url[j] = '\0';

    return sanitized_url;
}

// Main function
int main() {
    char *url = "https://www.example.com/path/to/file.html?query=string&param=value";

    char *sanitized_url = sanitize_url(url);
    if (sanitized_url == NULL) {
        printf("Error: Unable to sanitize URL.\n");
        return EXIT_FAILURE;
    }

    printf("Original URL: %s\n", url);
    printf("Sanitized URL: %s\n", sanitized_url);

    free(sanitized_url);

    return EXIT_SUCCESS;
}