//Gemma-7B DATASET v1.0 Category: Cafe Billing System ; Style: excited
#include <stdio.h>
#include <stdlib.h>

#define MAX_ITEMS 10

typedef struct Item {
  char name[50];
  int quantity;
  float price;
} Item;

Item items[MAX_ITEMS];

void addItem(char name[], int quantity, float price) {
  for (int i = 0; i < MAX_ITEMS; i++) {
    if (items[i].name[0] == '\0') {
      strcpy(items[i].name, name);
      items[i].quantity = quantity;
      items[i].price = price;
      return;
    }
  }

  printf("Error: Item limit reached.\n");
}

void printItems() {
  for (int i = 0; i < MAX_ITEMS; i++) {
    if (items[i].name[0] != '\0') {
      printf("%s: %d, $%.2f\n", items[i].name, items[i].quantity, items[i].price);
    }
  }
}

int calculateTotal(int quantity) {
  int total = 0;
  for (int i = 0; i < MAX_ITEMS; i++) {
    if (strcmp(items[i].name, "Coffee") == 0) {
      total += items[i].quantity * quantity;
    }
  }

  return total;
}

int main() {
  addItem("Coffee", 10, 2.50);
  addItem("Tea", 5, 1.20);
  addItem("Juice", 2, 1.80);

  printItems();

  int total = calculateTotal(3);
  printf("Total: %d\n", total);

  return 0;
}