//GEMINI-pro DATASET v1.0 Category: Greedy Algorithms ; Style: enthusiastic
#include <stdio.h>
#include <stdlib.h>

// A custom data structure represent an activity
typedef struct Activity {
  int start;  // Start time of the activity
  int end;    // End time of the activity
} Activity;

// A comparison function to sort activities based on their finish times
int compareActivities(const void* a, const void* b) {
  Activity* a1 = (Activity*)a;
  Activity* a2 = (Activity*)b;
  return a1->end - a2->end;
}

// A greedy algorithm to find the maximum number of non-overlapping activities
int maxActivities(Activity* activities, int n) {
  // Sort the activities based on their finish times
  qsort(activities, n, sizeof(Activity), compareActivities);

  // Initialize the count of non-overlapping activities to 1
  int count = 1;

  // Initialize the previous finish time to the finish time of the first activity
  int prev_finish = activities[0].end;

  // Iterate over the remaining activities
  for (int i = 1; i < n; i++) {
    // If the start time of the current activity is greater than or equal to the
    // finish time of the previous activity, then the current activity is
    // non-overlapping and can be added to the count
    if (activities[i].start >= prev_finish) {
      count++;
      prev_finish = activities[i].end;
    }
  }

  // Return the count of non-overlapping activities
  return count;
}

// A utility function to print an array of activities
void printActivities(Activity* activities, int n) {
  for (int i = 0; i < n; i++) {
    printf("(%d, %d) ", activities[i].start, activities[i].end);
  }
  printf("\n");
}

int main() {
  // Initialize an array of activities
  Activity activities[] = {{1, 4}, {3, 5}, {0, 6}, {5, 7}, {3, 8}, {5, 9}, {6, 10}, {8, 11}};

  // Get the number of activities
  int n = sizeof(activities) / sizeof(activities[0]);

  // Print the original array of activities
  printf("Original array of activities:\n");
  printActivities(activities, n);

  // Find the maximum number of non-overlapping activities
  int max_activities = maxActivities(activities, n);

  // Print the maximum number of non-overlapping activities
  printf("Maximum number of non-overlapping activities: %d\n", max_activities);

  return 0;
}