//GEMINI-pro DATASET v1.0 Category: System administration ; Style: scientific
#include <stdio.h>
#include <stdlib.h>
#include <unistd.h>
#include <sys/types.h>
#include <sys/stat.h>
#include <fcntl.h>
#include <errno.h>
#include <string.h>

int main()
{
    // Open a file for writing
    int fd = open("test.txt", O_WRONLY | O_CREAT | O_TRUNC, 0644);
    if (fd == -1)
    {
        perror("open");
        return 1;
    }

    // Write some data to the file
    const char *data = "Hello, world!\n";
    ssize_t bytes_written = write(fd, data, strlen(data));
    if (bytes_written == -1)
    {
        perror("write");
        return 1;
    }

    // Close the file
    if (close(fd) == -1)
    {
        perror("close");
        return 1;
    }

    // Open the file for reading
    fd = open("test.txt", O_RDONLY);
    if (fd == -1)
    {
        perror("open");
        return 1;
    }

    // Read some data from the file
    char buffer[1024];
    ssize_t bytes_read = read(fd, buffer, sizeof(buffer));
    if (bytes_read == -1)
    {
        perror("read");
        return 1;
    }

    // Print the data to the console
    printf("%s", buffer);

    // Close the file
    if (close(fd) == -1)
    {
        perror("close");
        return 1;
    }

    return 0;
}