//GEMINI-pro DATASET v1.0 Category: Building a JSON Parser ; Style: configurable
#include <stdio.h>
#include <stdlib.h>
#include <string.h>

#define MAX_KEY_LEN 100
#define MAX_VALUE_LEN 1000

typedef struct json_object {
    char key[MAX_KEY_LEN];
    char value[MAX_VALUE_LEN];
    struct json_object *next;
} json_object;

json_object *parse_json(char *json_string) {
    json_object *head = NULL;
    json_object *current = NULL;
    char *key_start = NULL;
    char *value_start = NULL;
    char *key_end = NULL;
    char *value_end = NULL;
    int in_key = 0;
    int in_value = 0;

    for (char *c = json_string; *c != '\0'; c++) {
        if (*c == '"') {
            if (!in_key && !in_value) {
                key_start = c + 1;
                in_key = 1;
            } else if (in_key) {
                key_end = c;
                in_key = 0;
            } else if (in_value) {
                value_end = c;
                in_value = 0;
            }
        } else if (*c == ':') {
            if (in_key) {
                key_end = c - 1;
                in_key = 0;
            }
        } else if (*c == ',') {
            if (!in_key && !in_value) {
                continue;
            } else if (in_key) {
                key_end = c - 1;
                in_key = 0;
            } else if (in_value) {
                value_end = c - 1;
                in_value = 0;
            }
            json_object *new_object = malloc(sizeof(json_object));
            if (new_object == NULL) {
                return NULL;
            }
            strncpy(new_object->key, key_start, key_end - key_start + 1);
            strncpy(new_object->value, value_start, value_end - value_start + 1);
            new_object->next = NULL;
            if (head == NULL) {
                head = new_object;
                current = new_object;
            } else {
                current->next = new_object;
                current = new_object;
            }
        }
    }

    return head;
}

void print_json(json_object *json) {
    for (json_object *current = json; current != NULL; current = current->next) {
        printf("%s: %s\n", current->key, current->value);
    }
}

int main() {
    char *json_string = "{\"key1\": \"value1\", \"key2\": \"value2\", \"key3\": \"value3\"}";

    json_object *json = parse_json(json_string);
    if (json == NULL) {
        return 1;
    }

    print_json(json);

    return 0;
}