//Gemma-7B DATASET v1.0 Category: Haunted House Simulator ; Style: high level of detail
#include <stdio.h>
#include <stdlib.h>
#include <time.h>

#define MAX_GHOULS 5

typedef struct Ghost {
  char name[20];
  int room;
  int mood;
  int actions;
} Ghost;

Ghost ghosts[MAX_GHOULS] = {
  {"Mr. Bartholomew", 1, 3, 2},
  {"Mrs. Abigail", 2, 2, 1},
  {"Mr. Edgar", 3, 4, 3},
  {"Ms. Sophia", 4, 1, 2},
  {"Mr. William", 5, 3, 1}
};

int main() {
  int i, j, chosen_room, num_ghosts = 0;

  srand(time(NULL));

  // Choose a random room
  chosen_room = rand() % 5 + 1;

  // Count the number of ghosts in the chosen room
  for (i = 0; i < MAX_GHOULS; i++) {
    if (ghosts[i].room == chosen_room) {
      num_ghosts++;
    }
  }

  // Create a spooky atmosphere
  printf("\nThe hairs on your neck stand on end as you enter the haunted house...\n");

  // Describe the room
  printf("You are in room %d. It is a dark and eerie place. The only sounds are your own breathing and the ticking clock.\n", chosen_room);

  // Simulate ghostly encounters
  if (num_ghosts > 0) {
    printf("Suddenly, a cold wind blows through the room, and the hairs on your neck stand on end.\n");
    printf("You hear footsteps approaching, but when you turn around, there is nothing there.\n");
    printf("You feel a presence watching you, and your heart skips a beat.\n");
  }

  // End the simulation
  printf("\nYou have escaped the haunted house. You are safe... for now.\n");

  return 0;
}