//GEMINI-pro DATASET v1.0 Category: Medical Store Management System ; Style: dynamic
#include <stdio.h>
#include <stdlib.h>
#include <string.h>

// Define the maximum number of medicines and customers
#define MAX_MEDICINES 100
#define MAX_CUSTOMERS 100

// Define the structure of a medicine
typedef struct medicine {
  int id;
  char name[50];
  float price;
  int quantity;
} medicine;

// Define the structure of a customer
typedef struct customer {
  int id;
  char name[50];
  float balance;
} customer;

// Define the array of medicines
medicine medicines[MAX_MEDICINES];

// Define the array of customers
customer customers[MAX_CUSTOMERS];

// Define the current number of medicines
int num_medicines = 0;

// Define the current number of customers
int num_customers = 0;

// Function to add a new medicine
void add_medicine(char name[], float price, int quantity) {
  // Check if the array of medicines is full
  if (num_medicines == MAX_MEDICINES) {
    printf("Error: The array of medicines is full.\n");
    return;
  }

  // Add the new medicine to the array
  strcpy(medicines[num_medicines].name, name);
  medicines[num_medicines].price = price;
  medicines[num_medicines].quantity = quantity;

  // Increment the current number of medicines
  num_medicines++;
}

// Function to add a new customer
void add_customer(char name[], float balance) {
  // Check if the array of customers is full
  if (num_customers == MAX_CUSTOMERS) {
    printf("Error: The array of customers is full.\n");
    return;
  }

  // Add the new customer to the array
  strcpy(customers[num_customers].name, name);
  customers[num_customers].balance = balance;

  // Increment the current number of customers
  num_customers++;
}

// Function to sell a medicine to a customer
void sell_medicine(int medicine_id, int customer_id, int quantity) {
  // Check if the medicine is in stock
  if (medicines[medicine_id].quantity < quantity) {
    printf("Error: The medicine is not in stock.\n");
    return;
  }

  // Check if the customer has enough balance
  if (customers[customer_id].balance < medicines[medicine_id].price * quantity) {
    printf("Error: The customer does not have enough balance.\n");
    return;
  }

  // Deduct the quantity from the stock
  medicines[medicine_id].quantity -= quantity;

  // Add the price of the medicine to the customer's balance
  customers[customer_id].balance += medicines[medicine_id].price * quantity;

  // Print the receipt
  printf("Receipt:\n");
  printf("Medicine: %s\n", medicines[medicine_id].name);
  printf("Price: %f\n", medicines[medicine_id].price);
  printf("Quantity: %d\n", quantity);
  printf("Total: %f\n", medicines[medicine_id].price * quantity);
}

// Function to print the list of medicines
void print_medicines() {
  printf("List of Medicines:\n");
  for (int i = 0; i < num_medicines; i++) {
    printf("%d. %s (%f, %d)\n", medicines[i].id, medicines[i].name, medicines[i].price, medicines[i].quantity);
  }
}

// Function to print the list of customers
void print_customers() {
  printf("List of Customers:\n");
  for (int i = 0; i < num_customers; i++) {
    printf("%d. %s (%f)\n", customers[i].id, customers[i].name, customers[i].balance);
  }
}

// Main function
int main() {
  // Add some sample medicines to the array
  add_medicine("Paracetamol", 10.0, 100);
  add_medicine("Ibuprofen", 15.0, 50);
  add_medicine("Aspirin", 5.0, 200);

  // Add some sample customers to the array
  add_customer("John Doe", 1000.0);
  add_customer("Jane Doe", 500.0);

  // Sell a medicine to a customer
  sell_medicine(0, 0, 50);

  // Print the list of medicines
  print_medicines();

  // Print the list of customers
  print_customers();

  return 0;
}