//Falcon-180B DATASET v1.0 Category: Network Packet Monitoring ; Style: ultraprecise
#include <stdio.h>
#include <stdlib.h>
#include <string.h>
#include <pcap.h>
#include <arpa/inet.h>
#include <netinet/ip.h>
#include <sys/socket.h>
#include <netinet/in.h>
#include <unistd.h>

#define MAX_PACKET_SIZE 65535
#define SNAPLEN 65535
#define TRUE 1
#define FALSE 0

struct packet {
    u_char *data;
    int size;
};

pcap_t *handle;
char errbuf[PCAP_ERRBUF_SIZE];
char *dev;

void packet_handler(u_char *args, const struct pcap_pkthdr *header, const u_char *packet) {
    struct packet pkt;
    pkt.data = (u_char *) malloc(header->len);
    pkt.size = header->len;
    memcpy(pkt.data, packet, header->len);
    printf("Packet received of size %d\n", header->len);
    printf("Data: ");
    for (int i = 0; i < header->len; i++) {
        printf("%02X ", pkt.data[i]);
    }
    printf("\n");
    free(pkt.data);
}

int main(int argc, char *argv[]) {
    if (argc!= 2) {
        fprintf(stderr, "Usage: %s <interface>\n", argv[0]);
        exit(1);
    }
    dev = argv[1];

    handle = pcap_open_live(dev, SNAPLEN, 1, 1000, errbuf);
    if (handle == NULL) {
        fprintf(stderr, "Error opening interface %s: %s\n", dev, errbuf);
        exit(1);
    }

    pcap_loop(handle, -1, packet_handler, NULL);

    pcap_close(handle);
    return 0;
}