//Falcon2-11B DATASET v1.0 Category: Firewall ; Style: brave
#include <stdio.h>
#include <stdlib.h>
#include <string.h>
#include <unistd.h>
#include <sys/types.h>
#include <sys/socket.h>
#include <netinet/in.h>

#define PORT 8080

int main(int argc, char* argv[]) {
    // Create a socket
    int sockfd;
    struct sockaddr_in serveraddr;
    sockfd = socket(AF_INET, SOCK_STREAM, 0);
    if (sockfd < 0) {
        perror("ERROR opening socket");
        exit(EXIT_FAILURE);
    }
    
    // Set up the server address structure
    serveraddr.sin_family = AF_INET;
    serveraddr.sin_port = htons(PORT);
    serveraddr.sin_addr.s_addr = INADDR_ANY;
    
    // Bind the socket to the address
    if (bind(sockfd, (struct sockaddr*)&serveraddr, sizeof(serveraddr)) < 0) {
        perror("ERROR on binding");
        exit(EXIT_FAILURE);
    }
    
    // Listen for incoming connections
    listen(sockfd, 5);
    
    // Accept incoming connection
    int clientfd = accept(sockfd, NULL, NULL);
    if (clientfd < 0) {
        perror("ERROR on accept");
        exit(EXIT_FAILURE);
    }
    
    // Receive data from the client
    char buf[1024];
    int n = recv(clientfd, buf, sizeof(buf), 0);
    if (n < 0) {
        perror("ERROR receiving data");
        exit(EXIT_FAILURE);
    }
    printf("Received: %s\n", buf);
    
    // Send data back to the client
    send(clientfd, buf, n, 0);
    close(clientfd);
    
    return 0;
}