//Gemma-7B DATASET v1.0 Category: CPU Scheduling Algorithms ; Style: creative
#include <stdio.h>
#include <stdlib.h>
#include <time.h>

#define MAX_PROCESSES 5
#define MAX_QUEUE_SIZE 10

typedef struct Process {
  int process_id;
  char name[20];
  int arrival_time;
  int burst_time;
  int waiting_time;
  int turn_around_time;
} Process;

void simulate_scheduler(Process processes[]) {
  int i, j, current_time = 0, quantum = 3;
  int ready_queue[MAX_QUEUE_SIZE] = {0};
  int completed_processes = 0;

  for (i = 0; i < MAX_PROCESSES; i++) {
    processes[i].waiting_time = 0;
    processes[i].turn_around_time = 0;
  }

  while (!completed_processes) {
    for (i = 0; i < MAX_PROCESSES; i++) {
      if (processes[i].arrival_time <= current_time && ready_queue[i] == 0) {
        ready_queue[i] = 1;
      }
    }

    if (ready_queue[0] == 1) {
      current_time++;
      processes[0].waiting_time++;
      processes[0].turn_around_time = current_time - processes[0].arrival_time;

      for (j = 0; j < MAX_PROCESSES; j++) {
        if (processes[j].arrival_time <= current_time && processes[j].burst_time > 0) {
          processes[j].burst_time--;
          if (processes[j].burst_time == 0) {
            completed_processes++;
          }
        }
      }
    } else {
      current_time++;
    }
  }

  for (i = 0; i < MAX_PROCESSES; i++) {
    printf("Process ID: %d, Name: %s, Arrival Time: %d, Burst Time: %d, Waiting Time: %d, Turnaround Time: %d\n", processes[i].process_id, processes[i].name, processes[i].arrival_time, processes[i].burst_time, processes[i].waiting_time, processes[i].turn_around_time);
  }
}

int main() {
  Process processes[MAX_PROCESSES] = {
    {1, "Process A", 0, 5, 0, 0},
    {2, "Process B", 2, 4, 0, 0},
    {3, "Process C", 3, 3, 0, 0},
    {4, "Process D", 1, 2, 0, 0},
    {5, "Process E", 4, 4, 0, 0}
  };

  simulate_scheduler(processes);

  return 0;
}