//GEMINI-pro DATASET v1.0 Category: Fitness Tracker ; Style: cheerful
#include <stdio.h>
#include <stdlib.h>
#include <string.h>

// Define the maximum number of steps that can be stored
#define MAX_STEPS 1000

// Define the structure of a fitness tracker entry
typedef struct {
    int steps;
    int distance;
    int calories;
    char date[11];
} FitnessTrackerEntry;

// Define the fitness tracker database
FitnessTrackerEntry database[MAX_STEPS];

// Define the current number of entries in the database
int numEntries = 0;

// Function to add a new entry to the database
void addEntry(int steps, int distance, int calories, char date[]) {
    // Check if the database is full
    if (numEntries == MAX_STEPS) {
        printf("The database is full. Please delete some entries before adding new ones.\n");
        return;
    }

    // Create a new entry
    FitnessTrackerEntry entry;
    entry.steps = steps;
    entry.distance = distance;
    entry.calories = calories;
    strcpy(entry.date, date);

    // Add the new entry to the database
    database[numEntries] = entry;
    numEntries++;
}

// Function to print the database
void printDatabase() {
    // Print the header
    printf("Steps\tDistance\tCalories\tDate\n");

    // Print each entry in the database
    for (int i = 0; i < numEntries; i++) {
        printf("%d\t%d\t%d\t%s\n", database[i].steps, database[i].distance, database[i].calories, database[i].date);
    }
}

// Function to delete an entry from the database
void deleteEntry(int index) {
    // Check if the index is valid
    if (index < 0 || index >= numEntries) {
        printf("Invalid index. Please enter a valid index.\n");
        return;
    }

    // Shift the entries after the deleted entry to the left
    for (int i = index; i < numEntries - 1; i++) {
        database[i] = database[i + 1];
    }

    // Decrement the number of entries in the database
    numEntries--;
}

// Function to get the total number of steps in the database
int getTotalSteps() {
    int totalSteps = 0;

    // Sum the steps for each entry in the database
    for (int i = 0; i < numEntries; i++) {
        totalSteps += database[i].steps;
    }

    return totalSteps;
}

// Function to get the average number of steps per day
float getAverageStepsPerDay() {
    // Check if the database is empty
    if (numEntries == 0) {
        printf("The database is empty. Please add some entries before calculating the average.\n");
        return 0;
    }

    // Calculate the total number of steps
    int totalSteps = getTotalSteps();

    // Calculate the average number of steps per day
    float averageStepsPerDay = (float)totalSteps / numEntries;

    return averageStepsPerDay;
}

// Function to get the longest distance walked in a single day
int getLongestDistance() {
    // Check if the database is empty
    if (numEntries == 0) {
        printf("The database is empty. Please add some entries before calculating the longest distance.\n");
        return 0;
    }

    // Initialize the longest distance to the first entry's distance
    int longestDistance = database[0].distance;

    // Iterate over the remaining entries in the database
    for (int i = 1; i < numEntries; i++) {
        // If the current entry's distance is greater than the longest distance, update the longest distance
        if (database[i].distance > longestDistance) {
            longestDistance = database[i].distance;
        }
    }

    return longestDistance;
}

// Function to get the most calories burned in a single day
int getMostCaloriesBurned() {
    // Check if the database is empty
    if (numEntries == 0) {
        printf("The database is empty. Please add some entries before calculating the most calories burned.\n");
        return 0;
    }

    // Initialize the most calories burned to the first entry's calories
    int mostCaloriesBurned = database[0].calories;

    // Iterate over the remaining entries in the database
    for (int i = 1; i < numEntries; i++) {
        // If the current entry's calories are greater than the most calories burned, update the most calories burned
        if (database[i].calories > mostCaloriesBurned) {
            mostCaloriesBurned = database[i].calories;
        }
    }

    return mostCaloriesBurned;
}

// Main function
int main() {
    // Add some sample entries to the database
    addEntry(10000, 5, 500, "2023-01-01");
    addEntry(12000, 6, 600, "2023-01-02");
    addEntry(14000, 7, 700, "2023-01-03");

    // Print the database
    printf("Fitness Tracker Database:\n");
    printDatabase();

    // Get the total number of steps
    printf("Total number of steps: %d\n", getTotalSteps());

    // Get the average number of steps per day
    printf("Average number of steps per day: %.2f\n", getAverageStepsPerDay());

    // Get the longest distance walked in a single day
    printf("Longest distance walked in a single day: %d\n", getLongestDistance());

    // Get the most calories burned in a single day
    printf("Most calories burned in a single day: %d\n", getMostCaloriesBurned());

    return 0;
}