//LLAMA2-13B DATASET v1.0 Category: Port Scanner ; Style: satisfied
#include <stdio.h>
#include <stdlib.h>
#include <string.h>
#include <sys/socket.h>
#include <netinet/in.h>
#include <arpa/inet.h>

#define PORT_RANGE 1024

int main() {
    int sock, port;
    struct sockaddr_in server_addr;
    char buffer[1024];

    // Create a socket
    sock = socket(AF_INET, SOCK_STREAM, 0);
    if (sock < 0) {
        perror("socket failed");
        exit(1);
    }

    // Set address and port
    server_addr.sin_family = AF_INET;
    server_addr.sin_port = htons(12345);
    inet_pton(AF_INET, "127.0.0.1", &server_addr.sin_addr);

    // Connect to the server
    if (connect(sock, (struct sockaddr *)&server_addr, sizeof(server_addr)) < 0) {
        perror("connect failed");
        exit(1);
    }

    // Send a SYN packet to the server
    send(sock, "SYN", 3, 0);

    // Wait for the server's response
    recv(sock, buffer, 1024, 0);

    // Check if the server's response is a SYN-ACK packet
    if (buffer[0] != 'S' || buffer[1] != 'Y' || buffer[2] != 'N' || buffer[3] != 'A' || buffer[4] != 'CK') {
        perror("invalid response");
        exit(1);
    }

    // Send an ACK packet to the server
    send(sock, "ACK", 3, 0);

    // Wait for the server's final response
    recv(sock, buffer, 1024, 0);

    // Check if the server's final response is a FIN-ACK packet
    if (buffer[0] != 'F' || buffer[1] != 'I' || buffer[2] != 'N' || buffer[3] != 'A' || buffer[4] != 'CK') {
        perror("invalid final response");
        exit(1);
    }

    // Close the socket
    close(sock);

    printf("Port scan successful! Port %d is open.\n", ntohs(server_addr.sin_port));

    return 0;
}