//GEMINI-pro DATASET v1.0 Category: CPU Scheduling Algorithms ; Style: curious
#include <stdio.h>
#include <stdlib.h>

struct Process {
  int pid;
  int arrival_time;
  int cpu_burst;
  int waiting_time;
  int turnaround_time;
};

int main() {

  struct Process processes[] = {
    {1, 0, 5, 0, 0},
    {2, 2, 3, 0, 0},
    {3, 4, 4, 0, 0},
    {4, 6, 2, 0, 0},
    {5, 8, 1, 0, 0}
  };

  int n = 5;
  int time = 0;
  int completed = 0;

  while (completed != n) {
    int shortest_job = -1;
    for (int i = 0; i < n; i++) {
      if (processes[i].arrival_time <= time && processes[i].cpu_burst > 0) {
        if (shortest_job == -1 || processes[i].cpu_burst < processes[shortest_job].cpu_burst) {
          shortest_job = i;
        }
      }
    }

    if (shortest_job != -1) {
      processes[shortest_job].cpu_burst--;
      time++;

      for (int i = 0; i < n; i++) {
        if (processes[i].arrival_time <= time && processes[i].cpu_burst > 0 && i != shortest_job) {
          processes[i].waiting_time++;
        }
      }

      if (processes[shortest_job].cpu_burst == 0) {
        processes[shortest_job].turnaround_time = time - processes[shortest_job].arrival_time;
        completed++;
      }
    } else {
      time++;
    }
  }

  printf("Process\tArrival Time\tCPU Burst\tWaiting Time\tTurnaround Time\n");
  for (int i = 0; i < n; i++) {
    printf("%d\t\t%d\t\t%d\t\t%d\t\t%d\n", processes[i].pid, processes[i].arrival_time, processes[i].cpu_burst, processes[i].waiting_time, processes[i].turnaround_time);
  }

  return 0;
}