//LLAMA2-13B DATASET v1.0 Category: Networking ; Style: modular
#include <stdio.h>
#include <stdlib.h>
#include <string.h>
#include <sys/socket.h>
#include <netinet/in.h>
#include <arpa/inet.h>

#define MAX_MESSAGE_LENGTH 1024

// Structure to represent a message
typedef struct {
    char *message;
    int length;
} message_t;

// Function to create a socket
int create_socket(void) {
    int sock = socket(AF_INET, SOCK_STREAM, 0);
    if (sock < 0) {
        perror("socket creation failed");
        exit(EXIT_FAILURE);
    }
    return sock;
}

// Function to connect to a server
int connect_to_server(int sock) {
    struct sockaddr_in server_addr;
    server_addr.sin_family = AF_INET;
    server_addr.sin_port = htons(8080);
    inet_pton(AF_INET, "127.0.0.1", &server_addr.sin_addr);
    if (connect(sock, (struct sockaddr *)&server_addr, sizeof(server_addr)) < 0) {
        perror("connection failed");
        exit(EXIT_FAILURE);
    }
    return sock;
}

// Function to send a message to the server
int send_message(int sock, char *message) {
    int sent = send(sock, message, strlen(message), 0);
    if (sent < 0) {
        perror("send failed");
        exit(EXIT_FAILURE);
    }
    return sent;
}

// Function to receive a message from the server
int receive_message(int sock, char *buffer, int buffer_size) {
    int received = recv(sock, buffer, buffer_size, 0);
    if (received < 0) {
        perror("receive failed");
        exit(EXIT_FAILURE);
    }
    return received;
}

int main(void) {
    int sock = create_socket();
    if (sock < 0) {
        exit(EXIT_FAILURE);
    }

    // Connect to the server
    sock = connect_to_server(sock);
    if (sock < 0) {
        exit(EXIT_FAILURE);
    }

    // Send a message to the server
    char message[] = "Hello, server!";
    int sent = send_message(sock, message);
    if (sent < 0) {
        exit(EXIT_FAILURE);
    }

    // Receive a message from the server
    char buffer[MAX_MESSAGE_LENGTH];
    int received = receive_message(sock, buffer, sizeof(buffer));
    if (received < 0) {
        exit(EXIT_FAILURE);
    }

    // Print the received message
    printf("Received message: %s\n", buffer);

    // Close the socket
    close(sock);

    return 0;
}