//Falcon-180B DATASET v1.0 Category: Networking ; Style: mind-bending
#include <stdio.h>
#include <stdlib.h>
#include <string.h>
#include <unistd.h>
#include <arpa/inet.h>
#include <sys/socket.h>
#include <netdb.h>

#define BUFFER_SIZE 1024
#define SERVER_PORT 8080

void error_handling(char *message) {
    perror(message);
    exit(1);
}

int main(int argc, char *argv[]) {

    int sockfd, newsockfd, portno;
    struct sockaddr_in serv_addr, cli_addr;
    int opt = 1;
    char buffer[BUFFER_SIZE];

    // Create socket
    sockfd = socket(AF_INET, SOCK_STREAM, 0);
    if (sockfd == 0)
        error_handling("socket failed");

    puts("Socket created");

    // Set options on the socket
    if (setsockopt(sockfd, SOL_SOCKET, SO_REUSEADDR | SO_REUSEPORT, &opt, sizeof(opt)))
        error_handling("setsockopt");

    puts("setsockopt done");

    // Connect to remote server
    serv_addr.sin_family = AF_INET;
    serv_addr.sin_addr.s_addr = inet_addr("127.0.0.1");
    serv_addr.sin_port = htons(SERVER_PORT);

    if (connect(sockfd, (struct sockaddr *)&serv_addr, sizeof(serv_addr)) < 0)
        error_handling("connect failed");

    puts("Connected to the server");

    // Send data to the server
    send(sockfd, "Hello, World!", strlen("Hello, World!"), 0);

    puts("Data sent to the server");

    // Receive data from the server
    memset(buffer, '\0', BUFFER_SIZE);
    recv(sockfd, buffer, BUFFER_SIZE, 0);

    puts("Data received from the server:");
    puts(buffer);

    // Close socket
    close(sockfd);

    puts("Socket closed");

    return 0;
}