//GPT-4o-mini DATASET v1.0 Category: Metadata Extractor ; Style: immersive
#include <stdio.h>
#include <stdlib.h>
#include <jpeglib.h>
#include <setjmp.h>

struct my_error_mgr {
    struct jpeg_error_mgr pub;
    jmp_buf setjmp_buffer;
};

typedef struct my_error_mgr * my_error_ptr;

void my_error_exit(j_common_ptr cinfo) {
    my_error_ptr myerr = (my_error_ptr)cinfo->err;
    (*cinfo->err->output_message)(cinfo);
    longjmp(myerr->setjmp_buffer, 1);
}

void extract_jpeg_metadata(const char *filename) {
    struct jpeg_decompress_struct cinfo;
    struct my_error_mgr jerr;

    FILE *infile;
    if ((infile = fopen(filename, "rb")) == NULL) {
        fprintf(stderr, "Can't open %s\n", filename);
        return;
    }

    cinfo.err = jpeg_std_error(&jerr.pub);
    jerr.pub.error_exit = my_error_exit;

    if (setjmp(jerr.setjmp_buffer)) {
        jpeg_destroy_decompress(&cinfo);
        fclose(infile);
        return;
    }

    jpeg_create_decompress(&cinfo);
    jpeg_stdio_src(&cinfo, infile);
    jpeg_read_header(&cinfo, TRUE);
    
    printf("JPEG Image Metadata:\n");
    printf(" - File: %s\n", filename);
    printf(" - Image Width: %d pixels\n", cinfo.image_width);
    printf(" - Image Height: %d pixels\n", cinfo.image_height);
    
    const char *color_space;
    switch(cinfo.jpeg_color_space) {
        case JCS_GRAYSCALE: color_space = "Grayscale"; break;
        case JCS_RGB: color_space = "RGB"; break;
        case JCS_YCbCr: color_space = "YCbCr"; break;
        case JCS_CMYK: color_space = "CMYK"; break;
        case JCS_YCCK: color_space = "YCCK"; break;
        default: color_space = "Unknown"; break;
    }
    printf(" - Color Space: %s\n", color_space);
    
    jpeg_start_decompress(&cinfo);
    jpeg_finish_decompress(&cinfo);
    jpeg_destroy_decompress(&cinfo);
    fclose(infile);
}

int main(int argc, char **argv) {
    if (argc < 2) {
        fprintf(stderr, "Usage: %s <jpeg-file>\n", argv[0]);
        return EXIT_FAILURE;
    }

    const char *filename = argv[1];
    extract_jpeg_metadata(filename);

    return EXIT_SUCCESS;
}