//Falcon-180B DATASET v1.0 Category: Robot movement control ; Style: happy
#include <stdio.h>
#include <stdlib.h>

// Define the robot's coordinates
#define X 0
#define Y 0

// Define the directions the robot can move
#define UP 1
#define DOWN -1
#define LEFT -1
#define RIGHT 1

// Define the maximum number of steps the robot can take
#define MAX_STEPS 100

// Define the robot's initial direction
#define INITIAL_DIRECTION UP

// Define the robot's initial coordinates
#define INITIAL_X 0
#define INITIAL_Y 0

// Define the robot's speed
#define SPEED 1

// Define the robot's current coordinates
int x = INITIAL_X;
int y = INITIAL_Y;

// Define the robot's current direction
int direction = INITIAL_DIRECTION;

// Define the robot's current step count
int step_count = 0;

// Define the robot's movement function
void move_robot() {
    // Move the robot in the current direction
    if (direction == UP) {
        y -= SPEED;
    }
    else if (direction == DOWN) {
        y += SPEED;
    }
    else if (direction == LEFT) {
        x -= SPEED;
    }
    else if (direction == RIGHT) {
        x += SPEED;
    }

    // Check if the robot has reached its maximum number of steps
    if (step_count >= MAX_STEPS) {
        // If so, change the robot's direction
        if (direction == UP) {
            direction = LEFT;
        }
        else if (direction == DOWN) {
            direction = RIGHT;
        }
        else if (direction == LEFT) {
            direction = DOWN;
        }
        else if (direction == RIGHT) {
            direction = UP;
        }

        // Reset the robot's step count
        step_count = 0;
    }
    else {
        // Otherwise, increment the robot's step count
        step_count++;
    }
}

// Define the robot's main function
int main() {
    // Initialize the robot's coordinates
    x = INITIAL_X;
    y = INITIAL_Y;

    // Initialize the robot's direction
    direction = INITIAL_DIRECTION;

    // Initialize the robot's step count
    step_count = 0;

    // Move the robot
    move_robot();

    // Print the robot's final coordinates
    printf("The robot ended up at coordinates (%d, %d)\n", x, y);

    return 0;
}