//GPT-4o-mini DATASET v1.0 Category: Robot movement control ; Style: Claude Shannon
#include <stdio.h>
#include <stdlib.h>
#include <unistd.h>
#include <signal.h>
#include <stdbool.h>

#define GRID_SIZE 5
#define MAX_STEPS 50

typedef struct {
    int x;
    int y;
} Position;

Position robot_position;

enum Direction {
    UP,
    DOWN,
    LEFT,
    RIGHT
};

bool is_within_bounds(Position pos) {
    return (pos.x >= 0 && pos.x < GRID_SIZE && pos.y >= 0 && pos.y < GRID_SIZE);
}

void print_grid() {
    for (int i = 0; i < GRID_SIZE; i++) {
        for (int j = 0; j < GRID_SIZE; j++) {
            if (i == robot_position.x && j == robot_position.y) {
                printf("[R] ");
            } else {
                printf("[ ] ");
            }
        }
        printf("\n");
    }
    printf("\n");
}

void move_robot(enum Direction dir) {
    Position new_position = robot_position;
    switch (dir) {
        case UP:
            new_position.x--;
            break;
        case DOWN:
            new_position.x++;
            break;
        case LEFT:
            new_position.y--;
            break;
        case RIGHT:
            new_position.y++;
            break;
    }

    if (is_within_bounds(new_position)) {
        robot_position = new_position;
        printf("Robot moved to (%d, %d)\n", robot_position.x, robot_position.y);
    } else {
        printf("Move out of bounds ignored.\n");
    }
}

void change_direction_and_move(int step_count) {
    enum Direction current_direction = UP;
    for (int step = 0; step < step_count; step++) {
        printf("Step %d: ", step + 1);
        print_grid();
        move_robot(current_direction);
        current_direction = (current_direction + 1) % 4; // Change direction in a circular manner
        usleep(500000); // Sleep for half a second to visualize the movement
    }
}

void signal_handler(int sig) {
    if (sig == SIGINT) {
        printf("Interrupt signal received. Stopping the robot.\n");
        exit(0);
    }
}

int main() {
    signal(SIGINT, signal_handler); // Handle ctrl+c to stop the program gracefully
    robot_position.x = GRID_SIZE / 2;
    robot_position.y = GRID_SIZE / 2;

    printf("Robot initialized at (%d, %d)\n", robot_position.x, robot_position.y);
    printf("Starting the robot movements...\n");

    change_direction_and_move(MAX_STEPS);

    printf("Movement completed. Final Robot position: (%d, %d)\n", robot_position.x, robot_position.y);
    return 0;
}