//Code Llama-13B DATASET v1.0 Category: Expense Tracker ; Style: recursive
/*
 * Expense Tracker
 *
 * A simple program to keep track of expenses using a recursive style.
 *
 */

#include <stdio.h>

// Define a struct to store expense information
struct Expense {
    char category[10];
    float amount;
};

// Define a function to display expense information
void displayExpense(struct Expense exp) {
    printf("Category: %s\nAmount: %.2f\n\n", exp.category, exp.amount);
}

// Define a function to add expense information
struct Expense addExpense(struct Expense exp, char *category, float amount) {
    strcpy(exp.category, category);
    exp.amount += amount;
    return exp;
}

// Define a function to remove expense information
struct Expense removeExpense(struct Expense exp, char *category, float amount) {
    strcpy(exp.category, category);
    exp.amount -= amount;
    return exp;
}

// Define a function to print the total expenses
void printTotal(struct Expense exp) {
    printf("Total: %.2f\n", exp.amount);
}

// Define a function to add expenses recursively
struct Expense addExpenses(struct Expense exp, int n) {
    if (n == 0) {
        return exp;
    }
    else {
        struct Expense newExp = addExpense(exp, "Food", 10.0);
        return addExpenses(newExp, n - 1);
    }
}

int main() {
    // Initialize the expense information
    struct Expense exp = {"Food", 10.0};

    // Add expenses
    exp = addExpenses(exp, 4);

    // Display the total expenses
    printTotal(exp);

    // Remove expenses
    exp = removeExpense(exp, "Food", 20.0);

    // Display the updated total expenses
    printTotal(exp);

    return 0;
}