//LLAMA2-13B DATASET v1.0 Category: File handling ; Style: happy
#include <stdio.h>
#include <stdlib.h>
#include <string.h>
#include <sys/types.h>
#include <unistd.h>
#include <fcntl.h>

// Define the file name and mode
#define FILE_NAME "happy_file.txt"
#define MODE "w"

// Function to open the file in write mode
void open_file(void) {
    int fd;

    // Try to open the file
    if ((fd = open(FILE_NAME, O_RDWR | O_CREAT, 0644)) == -1) {
        perror("Error opening file");
        exit(EXIT_FAILURE);
    }

    // Check if the file was opened successfully
    if (fd == -1) {
        perror("Error opening file");
        exit(EXIT_FAILURE);
    }

    // Print a happy message
    printf("Yay! We opened the file successfully! 😄\n");
}

// Function to write to the file
void write_to_file(const char* message) {
    int fd;

    // Try to open the file
    if ((fd = open(FILE_NAME, O_RDWR, 0644)) == -1) {
        perror("Error opening file");
        exit(EXIT_FAILURE);
    }

    // Write the message to the file
    write(fd, message, strlen(message));

    // Close the file
    close(fd);

    // Print a happy message
    printf("Yay! We wrote to the file successfully! 😄\n");
}

int main(void) {
    // Open the file in write mode
    open_file();

    // Write some happy messages to the file
    write_to_file("Hello, world!");
    write_to_file("Happy coding!");
    write_to_file("Yay for files!");

    // Close the file
    close(fileno(stdin));

    // Print a happy message
    printf("Yay! We closed the file successfully! 😄\n");

    return 0;
}