//Falcon-180B DATASET v1.0 Category: Drone Remote Control ; Style: Donald Knuth
#include <stdio.h>
#include <stdlib.h>
#include <string.h>

// Define the maximum number of drones that can be controlled
#define MAX_DRONES 10

// Define the structure for a drone
typedef struct {
    char name[20];
    int x;
    int y;
    int z;
} Drone;

// Define the structure for a drone fleet
typedef struct {
    Drone drones[MAX_DRONES];
    int num_drones;
} DroneFleet;

// Initialize the drone fleet
void init_drone_fleet(DroneFleet* fleet) {
    fleet->num_drones = 0;
}

// Add a drone to the fleet
void add_drone(DroneFleet* fleet, char* name, int x, int y, int z) {
    if (fleet->num_drones >= MAX_DRONES) {
        printf("Error: Drone fleet is full.\n");
        return;
    }

    strcpy(fleet->drones[fleet->num_drones].name, name);
    fleet->drones[fleet->num_drones].x = x;
    fleet->drones[fleet->num_drones].y = y;
    fleet->drones[fleet->num_drones].z = z;

    fleet->num_drones++;
}

// Move a drone in the fleet
void move_drone(DroneFleet* fleet, int idx, int dx, int dy, int dz) {
    if (idx >= fleet->num_drones) {
        printf("Error: Invalid drone index.\n");
        return;
    }

    fleet->drones[idx].x += dx;
    fleet->drones[idx].y += dy;
    fleet->drones[idx].z += dz;
}

// Print the current position of a drone in the fleet
void print_drone_position(const DroneFleet* fleet, int idx) {
    if (idx >= fleet->num_drones) {
        printf("Error: Invalid drone index.\n");
        return;
    }

    printf("Drone '%s' is at (%d, %d, %d).\n", fleet->drones[idx].name, fleet->drones[idx].x, fleet->drones[idx].y, fleet->drones[idx].z);
}

// Main function
int main() {
    DroneFleet fleet;
    init_drone_fleet(&fleet);

    // Add some drones to the fleet
    add_drone(&fleet, "Drone 1", 0, 0, 0);
    add_drone(&fleet, "Drone 2", 10, 10, 10);

    // Move some drones around
    move_drone(&fleet, 0, 5, 5, 5);
    move_drone(&fleet, 1, -5, -5, -5);

    // Print the current positions of the drones
    print_drone_position(&fleet, 0);
    print_drone_position(&fleet, 1);

    return 0;
}