//GPT-4o-mini DATASET v1.0 Category: QR code generator ; Style: Linus Torvalds
#include <stdio.h>
#include <stdlib.h>
#include <string.h>
#include <math.h>

#define QR_VERSION 1
#define SIZE 21
#define MODULE_SIZE 3

void fillModule(int qr[SIZE][SIZE], int x, int y, int size) {
    for (int i = 0; i < size; i++) {
        for (int j = 0; j < size; j++) {
            qr[y + i][x + j] = 1;
        }
    }
}

void drawFinderPattern(int qr[SIZE][SIZE], int x, int y) {
    fillModule(qr, x, y, MODULE_SIZE);
    fillModule(qr, x + MODULE_SIZE, y, MODULE_SIZE);
    fillModule(qr, x, y + MODULE_SIZE, MODULE_SIZE);
    fillModule(qr, x + MODULE_SIZE, y + MODULE_SIZE, MODULE_SIZE);
    qr[y + 1][x + 1] = 0; // Inner square
}

void initQR(int qr[SIZE][SIZE]) {
    for (int i = 0; i < SIZE; i++) {
        for (int j = 0; j < SIZE; j++) {
            qr[i][j] = 0;
        }
    }
}

void drawQR(int qr[SIZE][SIZE]) {
    for (int i = 0; i < SIZE; i++) {
        for (int j = 0; j < SIZE; j++) {
            if (qr[i][j]) {
                printf("██");
            } else {
                printf("  ");
            }
        }
        printf("\n");
    }
}

void generateQR(int qr[SIZE][SIZE], const char *data) {
    // For simplicity, this just adds finder patterns and some data.
    drawFinderPattern(qr, 0, 0);
    drawFinderPattern(qr, SIZE - MODULE_SIZE * 3, 0);
    drawFinderPattern(qr, 0, SIZE - MODULE_SIZE * 3);

    // In a real QR implementation, you would add encoding for the data here.
    printf("QR Code Version: %d\n", QR_VERSION);
    printf("Encoded Data: %s\n", data);
}

int main(int argc, char *argv[]) {
    if (argc != 2) {
        fprintf(stderr, "Usage: %s <data_to_encode>\n", argv[0]);
        return EXIT_FAILURE;
    }

    int qr[SIZE][SIZE];
    initQR(qr);
    generateQR(qr, argv[1]);
    drawQR(qr);

    return EXIT_SUCCESS;
}