//MISTRAL-7B DATASET v1.0 Category: Memory Game ; Style: light-weight
#include <stdio.h>
#include <stdlib.h>
#include <time.h>

#define ROWS 4
#define COLS 4
#define NUM_PAIRS COLS * COLS

int main() {
    int grid[ROWS][COLS], guess[2];
    int i, j, count, flag = 0;
    char answer[NUM_PAIRS + 1];

    srand(time(NULL)); // initialize random number generator

    // Initialize the grid with random numbers
    for (i = 0; i < ROWS; i++) {
        for (j = 0; j < COLS; j++) {
            grid[i][j] = rand() % 10;
            printf("%d ", grid[i][j]);
        }
        printf("\n");
    }

    printf("\n");

    // Player turns
    for (count = 0; count < NUM_PAIRS; count++) {
        do {
            i = rand() % ROWS;
            j = rand() % COLS;
            flag = 0;
            guess[0] = i;
            guess[1] = j;
        } while (grid[guess[0]][guess[1]] == 0 || grid[guess[0]][guess[1]] == grid[i][j]);

        // Store the pair in the answer string
        answer[count * 2] = '(';
        answer[count * 2 + 1] = 'A' + i;
        answer[count * 2 + 2] = ',';
        answer[count * 2 + 3] = ' ';
        answer[count * 2 + 4] = 'B' + j;
        answer[count * 2 + 5] = ')';

        printf("Pair %d: (%c, %c)\n", count + 1, 'A' + i, 'B' + j);
        scanf("%d %d", &i, &j);
    }

    printf("Congratulations! You have matched all pairs.\n");
    printf("Your answer: %s\n", answer);

    return 0;
}