//GEMINI-pro DATASET v1.0 Category: Bucket Sort Implementation ; Style: creative
#include <stdio.h>
#include <stdlib.h>

// Colors for console output
#define RED "\x1B[31m"
#define GREEN "\x1B[32m"
#define BLUE "\x1B[34m"
#define RESET "\x1B[0m"

// Function to print an array
void printArray(int *arr, int size) {
    for (int i = 0; i < size; i++) {
        printf("%d ", arr[i]);
    }
    printf("\n");
}

// Function to sort an array using bucket sort
void bucketSort(int *arr, int size) {

    // Organize numbers into buckets
    int buckets[size];
    for (int i = 0; i < size; i++) {
        buckets[i] = 0;
    }

    for (int i = 0; i < size; i++) {
        buckets[arr[i]]++;
    }

    // Reset input array
    for (int i = 0; i < size; i++) {
        arr[i] = 0;
    }

    // Insert elements back into the input array in increasing order
    int j = 0;
    for (int i = 0; i < size; i++) {
        while (buckets[i] > 0) {
            arr[j++] = i;
            buckets[i]--;
        }
    }
}

// Driver code to test the bucket sort function
int main() {

    // Define an input array
    int arr[] = {5, 3, 1, 7, 4, 1, 2, 8, 6};
    int size = sizeof(arr) / sizeof(arr[0]);

    // Print the unsorted array
    printf(RED "Unsorted array: " RESET);
    printArray(arr, size);

    // Sort the array using bucket sort
    bucketSort(arr, size);

    // Print the sorted array
    printf(GREEN "Sorted array: " RESET);
    printArray(arr, size);

    return 0;
}