//GPT-4o-mini DATASET v1.0 Category: Network Packet Monitoring ; Style: inquisitive
#include <stdio.h>
#include <stdlib.h>
#include <string.h>
#include <unistd.h>
#include <arpa/inet.h>
#include <netinet/ip.h>
#include <netinet/udp.h>
#include <netinet/tcp.h>
#include <netinet/if_ether.h>
#include <pcap.h>

#define MAX_PACKET_SIZE 65536

void packet_handler(u_char *args, const struct pcap_pkthdr *header, const u_char *packet) {
    struct ether_header *eth_header;
    struct ip *ip_header;
    struct tcphdr *tcp_header;
    struct udphdr *udp_header;
    u_char *payload;
    int payload_size;

    // Step 1: Ethernet Header Parsing
    eth_header = (struct ether_header *) packet;

    // Step 2: Check for IP packets
    if (ntohs(eth_header->ether_type) == ETHERTYPE_IP) {
        ip_header = (struct ip *)(packet + sizeof(struct ether_header));
        
        // Print IP header details
        printf("Source IP: %s\n", inet_ntoa(ip_header->ip_src));
        printf("Destination IP: %s\n", inet_ntoa(ip_header->ip_dst));
        printf("Protocol: %d\n", ip_header->ip_p);
        
        // Check the protocol and handle accordingly
        if (ip_header->ip_p == IPPROTO_TCP) {
            // TCP Packet
            tcp_header = (struct tcphdr *)(packet + sizeof(struct ether_header) + sizeof(struct ip));
            printf("TCP Source Port: %d\n", ntohs(tcp_header->source));
            printf("TCP Destination Port: %d\n", ntohs(tcp_header->dest));
            payload = (u_char *)(packet + sizeof(struct ether_header) + sizeof(struct ip) + sizeof(struct tcphdr));
            payload_size = header->len - (sizeof(struct ether_header) + sizeof(struct ip) + sizeof(struct tcphdr));
        } else if (ip_header->ip_p == IPPROTO_UDP) {
            // UDP Packet
            udp_header = (struct udphdr *)(packet + sizeof(struct ether_header) + sizeof(struct ip));
            printf("UDP Source Port: %d\n", ntohs(udp_header->source));
            printf("UDP Destination Port: %d\n", ntohs(udp_header->dest));
            payload = (u_char *)(packet + sizeof(struct ether_header) + sizeof(struct ip) + sizeof(struct udphdr));
            payload_size = header->len - (sizeof(struct ether_header) + sizeof(struct ip) + sizeof(struct udphdr));
        } else {
            printf("Other Protocol: %d\n", ip_header->ip_p);
            return; // Return if the packet is not TCP or UDP
        }

        // Step 3: Print Payload
        printf("Payload size: %d bytes\n", payload_size);
        for (int i = 0; i < payload_size; i++) {
            printf("%02x ", payload[i]);
            if ((i + 1) % 16 == 0) {
                printf("\n");
            }
        }
        printf("\n-----------------------------------------\n");
    }
}

int main() {
    char *device;
    char error_buffer[PCAP_ERRBUF_SIZE];
    pcap_t *handle;

    // Step 1: Find the first network device
    device = pcap_lookupdev(error_buffer);
    if (device == NULL) {
        fprintf(stderr, "Couldn't find a default device: %s\n", error_buffer);
        return 1;
    }
    
    // Step 2: Open the device for live capture
    handle = pcap_open_live(device, MAX_PACKET_SIZE, 1, 1000, error_buffer);
    if (handle == NULL) {
        fprintf(stderr, "Couldn't open device %s: %s\n", device, error_buffer);
        return 1;
    }

    // Step 3: Capture packets
    printf("Listening on device %s...\n", device);
    pcap_loop(handle, 0, packet_handler, NULL);

    // Clean up
    pcap_close(handle);
    return 0;
}