//GEMINI-pro DATASET v1.0 Category: Product Inventory System ; Style: intelligent
#include <stdio.h>
#include <stdlib.h>
#include <string.h>

// Define the maximum number of products that can be stored in the inventory
#define MAX_PRODUCTS 100

// Define the structure of a product
typedef struct product {
  int id;
  char name[50];
  int quantity;
  float price;
} product;

// Define the structure of the inventory
typedef struct inventory {
  product products[MAX_PRODUCTS];
  int num_products;
} inventory;

// Function to create a new product
product create_product(int id, char *name, int quantity, float price) {
  product new_product;
  new_product.id = id;
  strcpy(new_product.name, name);
  new_product.quantity = quantity;
  new_product.price = price;
  return new_product;
}

// Function to add a product to the inventory
void add_product(inventory *inv, product product) {
  if (inv->num_products < MAX_PRODUCTS) {
    inv->products[inv->num_products] = product;
    inv->num_products++;
  } else {
    printf("Error: The inventory is full.\n");
  }
}

// Function to remove a product from the inventory
void remove_product(inventory *inv, int id) {
  int i;
  for (i = 0; i < inv->num_products; i++) {
    if (inv->products[i].id == id) {
      inv->products[i] = inv->products[inv->num_products - 1];
      inv->num_products--;
      break;
    }
  }
}

// Function to update the quantity of a product in the inventory
void update_quantity(inventory *inv, int id, int quantity) {
  int i;
  for (i = 0; i < inv->num_products; i++) {
    if (inv->products[i].id == id) {
      inv->products[i].quantity = quantity;
      break;
    }
  }
}

// Function to print the inventory
void print_inventory(inventory *inv) {
  int i;
  printf("Inventory:\n");
  for (i = 0; i < inv->num_products; i++) {
    printf("%d %s %d %.2f\n", inv->products[i].id, inv->products[i].name, inv->products[i].quantity, inv->products[i].price);
  }
}

// Main function
int main() {
  // Create a new inventory
  inventory inv;
  inv.num_products = 0;

  // Add some products to the inventory
  product product1 = create_product(1, "Apple", 10, 1.00);
  add_product(&inv, product1);
  product product2 = create_product(2, "Orange", 5, 1.50);
  add_product(&inv, product2);
  product product3 = create_product(3, "Banana", 15, 2.00);
  add_product(&inv, product3);

  // Print the inventory
  print_inventory(&inv);

  // Remove a product from the inventory
  remove_product(&inv, 2);

  // Print the inventory
  print_inventory(&inv);

  // Update the quantity of a product in the inventory
  update_quantity(&inv, 1, 20);

  // Print the inventory
  print_inventory(&inv);

  return 0;
}