//Falcon2-11B DATASET v1.0 Category: Smart home light control ; Style: Ada Lovelace
#include <stdio.h>
#include <unistd.h>
#include <sys/types.h>
#include <sys/stat.h>
#include <fcntl.h>
#include <termios.h>
#include <string.h>

int main() {
    int fd, port, status;
    struct termios options;
    char c;

    printf("Connecting to smart home light...\n");
    fd = open("/dev/ttyUSB0", O_RDWR | O_NOCTTY | O_NDELAY);
    if (fd == -1) {
        printf("Failed to open serial port!\n");
        return 1;
    }

    printf("Resetting port options...\n");
    tcgetattr(fd, &options);
    options.c_cflag |= (CLOCAL | CREAD);
    options.c_cflag &= ~CSIZE;
    options.c_cflag |= CS8;
    options.c_iflag &= ~(IXON | IXOFF | IXANY);
    options.c_oflag &= ~OPOST;
    options.c_lflag &= ~(ICANON | ECHO | ECHOE | ISIG);
    tcsetattr(fd, TCSANOW, &options);

    printf("Setting baud rate to 9600...\n");
    cfsetospeed(&options, B9600);
    cfsetispeed(&options, B9600);
    tcsetattr(fd, TCSANOW, &options);

    printf("Opening port /dev/ttyUSB0...\n");
    port = open("/dev/ttyUSB0", O_RDWR | O_NOCTTY | O_NDELAY);
    if (port == -1) {
        printf("Failed to open serial port!\n");
        return 1;
    }

    printf("Sending command to turn on lights...\n");
    write(fd, "ON\n", 3);
    status = read(fd, &c, 1);
    printf("Lights turned on? %d\n", status);

    printf("Sending command to turn off lights...\n");
    write(fd, "OFF\n", 3);
    status = read(fd, &c, 1);
    printf("Lights turned off? %d\n", status);

    printf("Closing port /dev/ttyUSB0...\n");
    close(fd);
    close(port);

    return 0;
}