//Falcon-180B DATASET v1.0 Category: Bitwise operations ; Style: ephemeral
#include <stdio.h>
#include <stdlib.h>

#define NUM_BITS 32

void print_binary(int n) {
  char binary[NUM_BITS];
  int i = 0;
  while (n > 0) {
    binary[i++] = n % 2 + '0';
    n /= 2;
  }
  printf("%s\n", binary);
}

int main() {
  int num1 = 42;
  int num2 = 13;
  int and_result, or_result, xor_result, left_shift_result, right_shift_result;
  
  // Bitwise AND operation
  and_result = num1 & num2;
  printf("Bitwise AND: ");
  print_binary(num1);
  printf(" AND ");
  print_binary(num2);
  printf(" = ");
  print_binary(and_result);
  
  // Bitwise OR operation
  or_result = num1 | num2;
  printf("\nBitwise OR: ");
  print_binary(num1);
  printf(" OR ");
  print_binary(num2);
  printf(" = ");
  print_binary(or_result);
  
  // Bitwise XOR operation
  xor_result = num1 ^ num2;
  printf("\nBitwise XOR: ");
  print_binary(num1);
  printf(" XOR ");
  print_binary(num2);
  printf(" = ");
  print_binary(xor_result);
  
  // Left shift operation
  left_shift_result = num1 << 2;
  printf("\nLeft shift by 2: ");
  print_binary(num1);
  printf(" << 2 = ");
  print_binary(left_shift_result);
  
  // Right shift operation
  right_shift_result = num2 >> 2;
  printf("\nRight shift by 2: ");
  print_binary(num2);
  printf(" >> 2 = ");
  print_binary(right_shift_result);
  
  return 0;
}