//Falcon-180B DATASET v1.0 Category: Encryption ; Style: grateful
#include <stdio.h>
#include <string.h>
#include <ctype.h>

#define MAX_KEY_LENGTH 100
#define MAX_MESSAGE_LENGTH 1000

void encrypt(char* message, char* key) {
    int message_length = strlen(message);
    int key_length = strlen(key);
    char encrypted_message[MAX_MESSAGE_LENGTH] = "";

    for (int i = 0; i < message_length; i++) {
        char current_char = toupper(message[i]);
        int current_index = current_char - 'A';

        if (current_char >= 'A' && current_char <= 'Z') {
            current_index = (current_index + key_length) % 26;
        }

        encrypted_message[i] = current_char;
    }

    printf("Encrypted message: %s\n", encrypted_message);
}

void decrypt(char* message, char* key) {
    int message_length = strlen(message);
    int key_length = strlen(key);
    char decrypted_message[MAX_MESSAGE_LENGTH] = "";

    for (int i = 0; i < message_length; i++) {
        char current_char = toupper(message[i]);
        int current_index = current_char - 'A';

        if (current_char >= 'A' && current_char <= 'Z') {
            current_index = (current_index - key_length + 26) % 26;
        }

        decrypted_message[i] = current_char;
    }

    printf("Decrypted message: %s\n", decrypted_message);
}

int main() {
    char message[MAX_MESSAGE_LENGTH] = "Hello, world! ";
    char key[MAX_KEY_LENGTH] = "secret";

    printf("Message: %s\n", message);
    printf("Key: %s\n", key);

    encrypt(message, key);
    decrypt(message, key);

    return 0;
}