//LLAMA2-13B DATASET v1.0 Category: String manipulation ; Style: dynamic
#include <stdio.h>
#include <string.h>

// Function to reverse a string
void reverse_string(char *str) {
    int i, j;
    char temp;

    for (i = 0, j = strlen(str) - 1; i < j; i++, j--) {
        temp = str[i];
        str[i] = str[j];
        str[j] = temp;
    }
}

// Function to find the first occurrence of a substring
char *find_first(char *haystack, char *needle) {
    int i, j;

    for (i = 0, j = strlen(haystack) - strlen(needle) + 1; i < j; i++) {
        if (strncmp(haystack + i, needle, strlen(needle)) == 0) {
            return haystack + i;
        }
    }

    return NULL;
}

int main() {
    char str[] = "The quick brown fox jumps over the lazy dog";
    char *ptr;

    // Reverse the string
    reverse_string(str);
    printf("Reversed string: %s\n", str);

    // Find the first occurrence of "the"
    ptr = find_first(str, "the");
    if (ptr != NULL) {
        printf("First occurrence of 'the': %s\n", ptr);
    } else {
        printf("No occurrence of 'the' found\n");
    }

    // Find the first occurrence of "fox"
    ptr = find_first(str, "fox");
    if (ptr != NULL) {
        printf("First occurrence of 'fox': %s\n", ptr);
    } else {
        printf("No occurrence of 'fox' found\n");
    }

    return 0;
}