//Falcon-180B DATASET v1.0 Category: Mailing list manager ; Style: creative
#include <stdio.h>
#include <stdlib.h>
#include <string.h>

#define MAX_LIST_SIZE 1000
#define MAX_NAME_LENGTH 50
#define MAX_EMAIL_LENGTH 100

typedef struct {
    char name[MAX_NAME_LENGTH];
    char email[MAX_EMAIL_LENGTH];
    int subscribed;
} Subscriber;

void addSubscriber(Subscriber* list, int size, char* name, char* email) {
    if (size >= MAX_LIST_SIZE) {
        printf("Error: List is full.\n");
        return;
    }

    strcpy(list[size].name, name);
    strcpy(list[size].email, email);
    list[size].subscribed = 1;

    printf("Subscriber added: %s (%s)\n", list[size].name, list[size].email);
}

void removeSubscriber(Subscriber* list, int size, char* email) {
    int i;

    for (i = 0; i < size; i++) {
        if (strcmp(list[i].email, email) == 0) {
            list[i].subscribed = 0;
            printf("Subscriber removed: %s (%s)\n", list[i].name, list[i].email);
            return;
        }
    }

    printf("Subscriber not found.\n");
}

void sendEmail(Subscriber* list, int size, char* subject, char* message) {
    int i;

    for (i = 0; i < size; i++) {
        if (list[i].subscribed) {
            printf("Sending email to %s (%s): %s\n", list[i].name, list[i].email, subject);
        }
    }
}

int main() {
    Subscriber list[MAX_LIST_SIZE];
    int size = 0;

    addSubscriber(list, size, "John Doe", "john@example.com");
    addSubscriber(list, size, "Jane Smith", "jane@example.com");

    sendEmail(list, size, "Test Email", "Hello, World!");

    removeSubscriber(list, size, "john@example.com");

    sendEmail(list, size, "Test Email 2", "Goodbye, World!");

    return 0;
}