//GPT-4o-mini DATASET v1.0 Category: Firewall ; Style: paranoid
#include <stdio.h>
#include <stdlib.h>
#include <string.h>
#include <unistd.h>
#include <arpa/inet.h>
#include <pcap.h>
#include <netinet/ip.h>

#define MAX_FILTER_LENGTH 256
#define SNAPLEN 65535
#define PROMISC 1
#define TIMEOUT 1000

void packet_handler(u_char *args, const struct pcap_pkthdr *header, const u_char *packet) {
    struct iphdr *ip_header = (struct iphdr *)(packet + 14); // Assuming Ethernet header is 14 bytes
    struct sockaddr_in source, dest;

    memset(&source, 0, sizeof(source));
    memset(&dest, 0, sizeof(dest));

    source.sin_addr.s_addr = ip_header->saddr;
    dest.sin_addr.s_addr = ip_header->daddr;

    printf("Packet captured:\n");
    printf("From: %s\n", inet_ntoa(source.sin_addr));
    printf("To: %s\n", inet_ntoa(dest.sin_addr));
    
    // This is just a simple filter for demonstration; paranoid filtering can be added here.
    char *block_list[] = {"192.168.1.10", "10.0.0.5"};
    int block_count = 2;

    for (int i = 0; i < block_count; i++) {
        if (strcmp(inet_ntoa(source.sin_addr), block_list[i]) == 0) {
            printf("Blocked packet from %s\n", inet_ntoa(source.sin_addr));
            return;
        } else if (strcmp(inet_ntoa(dest.sin_addr), block_list[i]) == 0) {
            printf("Blocked packet to %s\n", inet_ntoa(dest.sin_addr));
            return;
        }
    }
    printf("Packet allowed through\n");
}

void start_capturing(const char *dev) {
    char errbuf[PCAP_ERRBUF_SIZE];
    pcap_t *handle = pcap_open_live(dev, SNAPLEN, PROMISC, TIMEOUT, errbuf);
    
    if (handle == NULL) {
        fprintf(stderr, "Could not open device %s: %s\n", dev, errbuf);
        exit(EXIT_FAILURE);
    }

    pcap_loop(handle, 0, packet_handler, NULL);
    pcap_close(handle);
}

int main(int argc, char *argv[]) {
    if (argc != 2) {
        fprintf(stderr, "Usage: %s <device>\n", argv[0]);
        exit(EXIT_FAILURE);
    }

    const char *device = argv[1];
    printf("Starting packet capture on device: %s...\n", device);
    
    start_capturing(device);
    
    return 0; // Normally unreachable due to pcap_loop
}