//GPT-4o-mini DATASET v1.0 Category: Network Packet Monitoring ; Style: future-proof
#include <stdio.h>
#include <stdlib.h>
#include <string.h>
#include <pcap.h>
#include <netinet/ip.h>
#include <netinet/tcp.h>
#include <netinet/udp.h>
#include <arpa/inet.h>

#define SNAP_LEN 1518
#define PROMISCUOUS_MODE 1
#define TIMEOUT 1000

void packet_handler(u_char *args, const struct pcap_pkthdr *header, const u_char *packet) {
    struct ip *ip_header = (struct ip *)(packet + 14); // Skip Ethernet header
    int ip_header_length = ip_header->ip_hl * 4;

    printf("Packet captured at %s", ctime((const time_t*)&header->ts.tv_sec));
    printf("From: %s\n", inet_ntoa(ip_header->ip_src));
    printf("To: %s\n", inet_ntoa(ip_header->ip_dst));
    printf("Protocol: %d\n", ip_header->ip_p);
    printf("Packet length: %d bytes\n", header->len);

    // Check for TCP
    if (ip_header->ip_p == IPPROTO_TCP) {
        struct tcphdr *tcp_header = (struct tcphdr *)(packet + 14 + ip_header_length);
        printf("TCP Source Port: %u\n", ntohs(tcp_header->source));
        printf("TCP Destination Port: %u\n", ntohs(tcp_header->dest));
    }
    // Check for UDP
    else if (ip_header->ip_p == IPPROTO_UDP) {
        struct udphdr *udp_header = (struct udphdr *)(packet + 14 + ip_header_length);
        printf("UDP Source Port: %u\n", ntohs(udp_header->uh_sport));
        printf("UDP Destination Port: %u\n", ntohs(udp_header->uh_dport));
    }
    printf("---------------------------------------------------------\n");
}

int main(int argc, char *argv[]) {
    if (argc != 2) {
        fprintf(stderr, "Usage: %s <interface>\n", argv[0]);
        return EXIT_FAILURE;
    }

    char *dev = argv[1];
    char errbuf[PCAP_ERRBUF_SIZE];

    // Open device for capturing packets
    pcap_t *handle = pcap_open_live(dev, SNAP_LEN, PROMISCUOUS_MODE, TIMEOUT, errbuf);
    if (handle == NULL) {
        fprintf(stderr, "Could not open device %s: %s\n", dev, errbuf);
        return EXIT_FAILURE;
    }

    printf("Starting packet capture on %s...\n", dev);

    // Start the packet capture loop
    pcap_loop(handle, 0, packet_handler, NULL);

    // Close the pcap handle
    pcap_close(handle);
    return EXIT_SUCCESS;
}