//Falcon-180B DATASET v1.0 Category: Banking Record System ; Style: optimized
#include <stdio.h>
#include <stdlib.h>
#include <string.h>

#define MAX_ACCOUNTS 100
#define MAX_TRANSACTIONS 1000

typedef struct {
    int accountNumber;
    char name[50];
    double balance;
} Account;

typedef struct {
    int accountNumberFrom;
    int accountNumberTo;
    double amount;
    char description[100];
} Transaction;

Account accounts[MAX_ACCOUNTS];
Transaction transactions[MAX_TRANSACTIONS];
int numAccounts = 0;
int numTransactions = 0;

// Function to add a new account
void addAccount(int accountNumber, char* name, double balance) {
    if (numAccounts >= MAX_ACCOUNTS) {
        printf("Error: Cannot add more accounts.\n");
        return;
    }
    accounts[numAccounts].accountNumber = accountNumber;
    strcpy(accounts[numAccounts].name, name);
    accounts[numAccounts].balance = balance;
    numAccounts++;
}

// Function to add a new transaction
void addTransaction(int accountNumberFrom, int accountNumberTo, double amount, char* description) {
    if (numTransactions >= MAX_TRANSACTIONS) {
        printf("Error: Cannot add more transactions.\n");
        return;
    }
    transactions[numTransactions].accountNumberFrom = accountNumberFrom;
    transactions[numTransactions].accountNumberTo = accountNumberTo;
    transactions[numTransactions].amount = amount;
    strcpy(transactions[numTransactions].description, description);
    numTransactions++;
}

// Function to display all accounts
void displayAccounts() {
    printf("Accounts:\n");
    for (int i = 0; i < numAccounts; i++) {
        printf("%d - %s - $%.2f\n", accounts[i].accountNumber, accounts[i].name, accounts[i].balance);
    }
}

// Function to display all transactions
void displayTransactions() {
    printf("Transactions:\n");
    for (int i = 0; i < numTransactions; i++) {
        printf("%d -> %d - $%.2f - %s\n", transactions[i].accountNumberFrom, transactions[i].accountNumberTo, transactions[i].amount, transactions[i].description);
    }
}

// Function to transfer funds between accounts
void transferFunds(int fromAccountNumber, int toAccountNumber, double amount) {
    for (int i = 0; i < numAccounts; i++) {
        if (accounts[i].accountNumber == fromAccountNumber) {
            accounts[i].balance -= amount;
        } else if (accounts[i].accountNumber == toAccountNumber) {
            accounts[i].balance += amount;
        }
    }
    addTransaction(fromAccountNumber, toAccountNumber, amount, "Transfer");
}

int main() {
    addAccount(12345, "John Doe", 1000.00);
    addAccount(67890, "Jane Doe", 5000.00);
    addTransaction(12345, 67890, 200.00, "Payment");
    displayAccounts();
    displayTransactions();
    transferFunds(67890, 12345, 1000.00);
    displayAccounts();
    displayTransactions();
    return 0;
}