//GPT-4o-mini DATASET v1.0 Category: Threading Library Implementation ; Style: peaceful
#include <stdio.h>
#include <stdlib.h>
#include <pthread.h>
#include <unistd.h>
#include <string.h>

#define NUM_THREADS 5

// Structure to hold thread data
typedef struct {
    int thread_id;
    const char* message;
} ThreadData;

// Function that each thread will run
void* peaceful_task(void* threadarg) {
    ThreadData* data = (ThreadData*) threadarg;
    int thread_id = data->thread_id;
    const char* message = data->message;

    printf("Thread %d is starting...\n", thread_id);
    for (int i = 0; i < 5; i++) {
        usleep(500000); // Sleep for 0.5 seconds
        printf("Thread %d says: %s (%d)\n", thread_id, message, i+1);
    }
    printf("Thread %d is finishing.\n", thread_id);
    
    pthread_exit(NULL);
}

// Main program 
int main() {
    pthread_t threads[NUM_THREADS];
    ThreadData thread_data[NUM_THREADS];
    const char* messages[NUM_THREADS] = {
        "Embracing tranquility",
        "Finding inner peace",
        "Breathe in, breathe out",
        "Serenity is the goal",
        "Happiness is a journey"
    };

    // Create threads
    for (int i = 0; i < NUM_THREADS; i++) {
        thread_data[i].thread_id = i + 1;
        thread_data[i].message = messages[i];

        int rc = pthread_create(&threads[i], NULL, peaceful_task, (void*)&thread_data[i]);
        if (rc) {
            fprintf(stderr, "Error: unable to create thread %d, %d\n", i + 1, rc);
            exit(EXIT_FAILURE);
        }
    }

    // Wait for all threads to complete
    for (int i = 0; i < NUM_THREADS; i++) {
        pthread_join(threads[i], NULL);
    }

    printf("All threads have completed their tasks.\n");
    return 0;
}