//MISTRAL-7B DATASET v1.0 Category: Traffic Light Controller ; Style: real-life
#include <stdio.h>
#include <stdbool.h>
#include <stdlib.h>
#include <unistd.h>
#include <time.h>

#define NUM_LIGHTS 9
#define PHASES 2

bool lights[NUM_LIGHTS];

void init_lights() {
    int i;
    for (i = 0; i < NUM_LIGHTS; i++) {
        lights[i] = false;
    }
}

void red_phase() {
    lights[0] = true;
    lights[1] = true;
    lights[2] = true;
    lights[4] = true;
    lights[5] = true;
    lights[6] = true;
    sleep(5);
}

void green_phase() {
    lights[0] = false;
    lights[1] = false;
    lights[2] = false;
    lights[3] = true;
    lights[4] = false;
    lights[5] = false;
    lights[6] = true;
    lights[7] = false;
    lights[8] = false;
    sleep(5);
}

void yellow_phase() {
    lights[0] = true;
    lights[1] = true;
    lights[2] = false;
    lights[3] = false;
    lights[4] = true;
    lights[5] = true;
    lights[6] = false;
    lights[7] = false;
    lights[8] = false;
    sleep(2);
}

void print_lights() {
    int i;
    printf("\nCurrent traffic light states:\n");
    for (i = 0; i < NUM_LIGHTS; i++) {
        if (lights[i]) {
            printf("Light %d is %s\n", i + 1, lights[i] ? "Red" : "Green");
        } else {
            printf("Light %d is Yellow\n", i + 1);
        }
    }
}

int main() {
    int i;
    srand(time(NULL));

    init_lights();

    for (i = 0; i < 10; i++) {
        switch (rand() % 3) {
            case 0:
                red_phase();
                break;
            case 1:
                yellow_phase();
                break;
            case 2:
                green_phase();
                break;
        }
        print_lights();
    }

    return 0;
}