//GEMINI-pro DATASET v1.0 Category: Weather simulation ; Style: surprised
#include <stdio.h>
#include <stdlib.h>
#include <time.h>

// System Constants
#define SYS_CLOUDS_MAX 10
#define SYS_TEMP_MIN -50
#define SYS_TEMP_MAX 50
#define SYS_RAIN_CHANCE 0.3

// Cloud Types
enum { CLOUD_CLEAR, CLOUD_FEW, CLOUD_SCATTERED, CLOUD_BROKEN, CLOUD_OVERCAST };

// Weather Data
struct Weather {
    int temperature;
    enum { SUNNY, RAINY, SNOWY } condition;
    int clouds;
};

// Initialize Weather Data
struct Weather init_weather() {
    struct Weather weather;

    // Set Temperature
    weather.temperature = (rand() % (SYS_TEMP_MAX - SYS_TEMP_MIN + 1)) + SYS_TEMP_MIN;

    // Set Weather Condition
    if (rand() / (RAND_MAX + 1.0) < SYS_RAIN_CHANCE) {
        weather.condition = RAINY;
    } else if (weather.temperature < 0) {
        weather.condition = SNOWY;
    } else {
        weather.condition = SUNNY;
    }

    // Set Cloud Coverage
    weather.clouds = rand() % (SYS_CLOUDS_MAX + 1);

    return weather;
}

// Get Cloud Type Description
const char *get_cloud_description(int clouds) {
    switch (clouds) {
        case CLOUD_CLEAR:
            return "Clear skies";
        case CLOUD_FEW:
            return "A few clouds";
        case CLOUD_SCATTERED:
            return "Scattered clouds";
        case CLOUD_BROKEN:
            return "Broken clouds";
        case CLOUD_OVERCAST:
            return "Overcast";
        default:
            return "Unknown cloud coverage";
    }
}

// Get Weather Condition Description
const char *get_condition_description(enum { SUNNY, RAINY, SNOWY } condition) {
    switch (condition) {
        case SUNNY:
            return "Sunny";
        case RAINY:
            return "Rainy";
        case SNOWY:
            return "Snowy";
        default:
            return "Unknown weather condition";
    }
}

// Print Weather Report
void print_weather_report(struct Weather weather) {
    printf("Weather Report:\n");
    printf("  Temperature: %d°C\n", weather.temperature);
    printf("  Condition: %s\n", get_condition_description(weather.condition));
    printf("  Clouds: %s\n", get_cloud_description(weather.clouds));
}

// Main Function
int main() {
    srand(time(NULL));  // Seed random number generator

    // Generate Weather Data
    struct Weather weather = init_weather();

    // Print Weather Report
    print_weather_report(weather);

    return 0;
}